/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.diff;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import net.sf.javagimmicks.collections.diff.Difference;
import net.sf.javagimmicks.collections.diff.DifferenceAlgorithm;
import net.sf.javagimmicks.collections.diff.DifferenceList;

public class DifferenceUtils {
    public static <T> DifferenceList<T> findDifferences(List<T> fromList, List<T> toList) {
        return new DifferenceAlgorithm<T>(fromList, toList, null).getDifferences();
    }

    public static <T> DifferenceList<T> findDifferences(T[] fromArray, T[] toArray) {
        return DifferenceUtils.findDifferences(Arrays.asList(fromArray), Arrays.asList(toArray));
    }

    public static <T> DifferenceList<T> findDifferences(List<T> fromList, List<T> toList, Comparator<T> comparator) {
        return new DifferenceAlgorithm<T>(fromList, toList, comparator).getDifferences();
    }

    public static <T> DifferenceList<T> findDifferences(T[] fromArray, T[] toArray, Comparator<T> comparator) {
        return DifferenceUtils.findDifferences(Arrays.asList(fromArray), Arrays.asList(toArray), comparator);
    }

    public static <T> Difference<T> getInvertedDifference(Difference<T> difference) {
        return new InvertedDifference<T>(difference);
    }

    public static <T> DifferenceList<T> getInvertedDifferenceList(DifferenceList<T> differenceList) {
        return new InvertedDifferenceList<T>(differenceList);
    }

    public static <T> void applyDifference(Difference<T> d, List<T> targetList) {
        int deleteStartIndex = d.getDeleteStartIndex();
        if (d.isDelete()) {
            ListIterator<T> iterator = targetList.listIterator(deleteStartIndex);
            for (int i = 0; i < d.getDeleteList().size(); ++i) {
                iterator.next();
                iterator.remove();
            }
        }
        if (d.isAdd()) {
            targetList.addAll(deleteStartIndex, d.getAddList());
        }
    }

    public static <T> void applyDifferenceList(DifferenceList<T> diffList, List<T> targetList) {
        ListIterator iterator = diffList.listIterator(diffList.size());
        while (iterator.hasPrevious()) {
            DifferenceUtils.applyDifference((Difference)iterator.previous(), targetList);
        }
    }

    public static String toString(Difference<?> d) {
        return "del(" + d.getDeleteStartIndex() + ", " + d.getDeleteEndIndex() + ")" + "|" + "add(" + d.getAddStartIndex() + ", " + d.getAddEndIndex() + ")";
    }

    protected static class InvertedDifferenceList<T>
    extends AbstractList<Difference<T>>
    implements DifferenceList<T> {
        protected final DifferenceList<T> _original;

        protected InvertedDifferenceList(DifferenceList<T> original) {
            this._original = original;
        }

        @Override
        public void add(int index, Difference<T> element) {
            this._original.add(index, element.invert());
        }

        @Override
        public Difference<T> get(int index) {
            return ((Difference)this._original.get(index)).invert();
        }

        @Override
        public Difference<T> remove(int index) {
            return ((Difference)this._original.remove(index)).invert();
        }

        @Override
        public Difference<T> set(int index, Difference<T> element) {
            return this._original.set(index, element.invert()).invert();
        }

        @Override
        public void applyTo(List<T> list) {
            DifferenceUtils.applyDifferenceList(this, list);
        }

        @Override
        public DifferenceList<T> invert() {
            return this._original;
        }

        @Override
        public int size() {
            return this._original.size();
        }
    }

    protected static class InvertedDifference<T>
    implements Difference<T> {
        protected final Difference<T> _original;

        protected InvertedDifference(Difference<T> original) {
            this._original = original;
        }

        @Override
        public int getAddStartIndex() {
            return this._original.getDeleteStartIndex();
        }

        @Override
        public int getAddEndIndex() {
            return this._original.getDeleteEndIndex();
        }

        @Override
        public List<T> getAddList() {
            return this._original.getDeleteList();
        }

        @Override
        public boolean isAdd() {
            return this._original.isDelete();
        }

        @Override
        public int getDeleteStartIndex() {
            return this._original.getAddStartIndex();
        }

        @Override
        public int getDeleteEndIndex() {
            return this._original.getAddEndIndex();
        }

        @Override
        public List<T> getDeleteList() {
            return this._original.getAddList();
        }

        @Override
        public boolean isDelete() {
            return this._original.isAdd();
        }

        @Override
        public Difference<T> invert() {
            return this._original;
        }

        public String toString() {
            return DifferenceUtils.toString(this);
        }
    }
}

