/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.sf.javagimmicks.collections.decorators.AbstractUnmodifiableCollectionDecorator;

public abstract class AbstractEventCollection<E>
extends AbstractUnmodifiableCollectionDecorator<E> {
    private static final long serialVersionUID = -8335291555421718053L;

    public AbstractEventCollection(Collection<E> decorated) {
        super(decorated);
    }

    @Override
    public boolean add(E e) {
        boolean result = this.getDecorated().add(e);
        if (result) {
            this.fireElementAdded(e);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Collection<E> decorated = this.getDecorated();
        ArrayList<E> added = new ArrayList<E>();
        for (E element : c) {
            if (!decorated.add(element)) continue;
            added.add(element);
        }
        if (!added.isEmpty()) {
            this.fireElementsAdded(added);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new EventCollectionIterator(this.getDecorated().iterator());
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.getDecorated().remove(o);
        if (result) {
            this.fireElementRemoved(o);
        }
        return result;
    }

    protected abstract void fireElementsAdded(Collection<? extends E> var1);

    protected abstract void fireElementRemoved(E var1);

    protected void fireElementAdded(E element) {
        this.fireElementsAdded(Collections.singleton(element));
    }

    protected class EventCollectionIterator
    implements Iterator<E> {
        protected final Iterator<E> _decorated;
        protected E _lastElement = null;

        public EventCollectionIterator(Iterator<E> decorated) {
            this._decorated = decorated;
        }

        @Override
        public boolean hasNext() {
            return this._decorated.hasNext();
        }

        @Override
        public E next() {
            this._lastElement = this._decorated.next();
            return this._lastElement;
        }

        @Override
        public void remove() {
            this._decorated.remove();
            AbstractEventCollection.this.fireElementRemoved(this._lastElement);
        }
    }
}

