/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.javagimmicks.collections.decorators.AbstractUnmodifiableListDecorator;

public abstract class AbstractEventList<E>
extends AbstractUnmodifiableListDecorator<E> {
    private static final long serialVersionUID = 7192864561064933670L;

    public AbstractEventList(List<E> decorated) {
        super(decorated);
    }

    @Override
    public void add(int index, E element) {
        this.getDecorated().add(index, element);
        this.fireElementAdded(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = this.getDecorated().addAll(index, c);
        this.fireElementsAdded(index, c);
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new EventListListIterator(this, index);
    }

    @Override
    public E remove(int index) {
        Object element = this.getDecorated().remove(index);
        this.fireElementRemoved(index, element);
        return element;
    }

    @Override
    public E set(int index, E element) {
        Object oldElement = this.getDecorated().set(index, element);
        this.fireElementUpdated(index, oldElement, element);
        return oldElement;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new EventSubList(this, fromIndex, toIndex);
    }

    protected abstract void fireElementsAdded(int var1, Collection<? extends E> var2);

    protected abstract void fireElementUpdated(int var1, E var2, E var3);

    protected abstract void fireElementRemoved(int var1, E var2);

    protected void fireElementAdded(int index, E element) {
        this.fireElementsAdded(index, Collections.singletonList(element));
    }

    protected static class EventSubList<E>
    extends AbstractEventList<E> {
        private static final long serialVersionUID = -3091453601436750348L;
        protected final AbstractEventList<E> _parent;
        protected final int _offset;

        protected EventSubList(AbstractEventList<E> parent, int fromIndex, int toIndex) {
            super(((AbstractEventList)parent)._decorated.subList(fromIndex, toIndex));
            this._parent = parent;
            this._offset = fromIndex;
        }

        @Override
        protected void fireElementsAdded(int index, Collection<? extends E> elements) {
            this._parent.fireElementsAdded(index + this._offset, elements);
        }

        @Override
        protected void fireElementRemoved(int index, E element) {
            this._parent.fireElementRemoved(index + this._offset, element);
        }

        @Override
        protected void fireElementUpdated(int index, E element, E newElement) {
            this._parent.fireElementUpdated(index + this._offset, element, newElement);
        }
    }

    protected static class EventListListIterator<E>
    implements ListIterator<E> {
        protected final AbstractEventList<E> _parent;
        protected final ListIterator<E> _decorated;
        protected int _lastIndex;

        public EventListListIterator(AbstractEventList<E> parent, int index) {
            this._parent = parent;
            this._decorated = ((AbstractEventList)this._parent)._decorated.listIterator(index);
        }

        @Override
        public void add(E e) {
            this._decorated.add(e);
            int index = this._decorated.previousIndex();
            this._parent.fireElementAdded(index, e);
        }

        @Override
        public void remove() {
            Object element = this._parent.get(this._lastIndex);
            this._decorated.remove();
            int index = this._decorated.nextIndex();
            this._parent.fireElementRemoved(index, element);
        }

        @Override
        public void set(E e) {
            Object oldElement = this._parent.get(this._lastIndex);
            this._decorated.set(e);
            this._parent.fireElementUpdated(this._lastIndex, oldElement, e);
        }

        @Override
        public E next() {
            E result = this._decorated.next();
            this._lastIndex = this._decorated.previousIndex();
            return result;
        }

        @Override
        public E previous() {
            E result = this._decorated.previous();
            this._lastIndex = this._decorated.nextIndex();
            return result;
        }

        @Override
        public boolean hasNext() {
            return this._decorated.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this._decorated.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this._decorated.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this._decorated.previousIndex();
        }
    }
}

