/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.collections.decorators.AbstractEntryDecorator;
import net.sf.javagimmicks.collections.decorators.AbstractIteratorDecorator;
import net.sf.javagimmicks.collections.decorators.AbstractUnmodifiableMapDecorator;
import net.sf.javagimmicks.collections.event.AbstractEventSet;

public abstract class AbstractEventMap<K, V>
extends AbstractUnmodifiableMapDecorator<K, V> {
    private static final long serialVersionUID = -2690296055006665266L;

    public AbstractEventMap(Map<K, V> decorated) {
        super(decorated);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EventMapEntrySet(this.getDecorated().entrySet());
    }

    @Override
    public V put(K key, V value) {
        boolean isUpdate = this.containsKey(key);
        Object oldValue = this.getDecorated().put(key, value);
        if (isUpdate) {
            this.fireEntryUpdated(key, oldValue, value);
        } else {
            this.fireEntryAdded(key, value);
        }
        return oldValue;
    }

    protected abstract void fireEntryAdded(K var1, V var2);

    protected abstract void fireEntryUpdated(K var1, V var2, V var3);

    protected abstract void fireEntryRemoved(K var1, V var2);

    protected class EventMapEntrySet
    extends AbstractEventSet<Map.Entry<K, V>> {
        private static final long serialVersionUID = 4496963842926801525L;

        protected EventMapEntrySet(Set<Map.Entry<K, V>> decorated) {
            super(decorated);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new AbstractIteratorDecorator<Map.Entry<K, V>>(super.iterator()){

                @Override
                public Map.Entry<K, V> next() {
                    return new AbstractEntryDecorator<K, V>((Map.Entry)super.next()){
                        private static final long serialVersionUID = -6377534237333144069L;

                        @Override
                        public V setValue(V value) {
                            Object oldValue = super.setValue(value);
                            AbstractEventMap.this.fireEntryUpdated(this.getKey(), oldValue, value);
                            return oldValue;
                        }
                    };
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException("Cannot directly add entries to the EntrySet of an AbstractEventMap!");
        }

        @Override
        protected void fireElementAdded(Map.Entry<K, V> element) {
        }

        @Override
        protected void fireElementReadded(Map.Entry<K, V> element) {
        }

        @Override
        protected void fireElementRemoved(Map.Entry<K, V> element) {
            AbstractEventMap.this.fireEntryRemoved(element.getKey(), element.getValue());
        }
    }
}

