/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.Iterator;
import java.util.Set;
import net.sf.javagimmicks.collections.decorators.AbstractUnmodifiableSetDecorator;

public abstract class AbstractEventSet<E>
extends AbstractUnmodifiableSetDecorator<E> {
    private static final long serialVersionUID = -7712383972215104949L;

    public AbstractEventSet(Set<E> decorated) {
        super(decorated);
    }

    @Override
    public boolean add(E e) {
        boolean result = this.getDecorated().add(e);
        if (result) {
            this.fireElementAdded(e);
        } else {
            this.fireElementReadded(e);
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return new EventSetIterator(this.getDecorated().iterator());
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.getDecorated().remove(o);
        if (result) {
            this.fireElementRemoved(o);
        }
        return result;
    }

    protected abstract void fireElementAdded(E var1);

    protected abstract void fireElementReadded(E var1);

    protected abstract void fireElementRemoved(E var1);

    protected class EventSetIterator
    implements Iterator<E> {
        protected final Iterator<E> _decorated;
        protected E _lastElement = null;

        public EventSetIterator(Iterator<E> decorated) {
            this._decorated = decorated;
        }

        @Override
        public boolean hasNext() {
            return this._decorated.hasNext();
        }

        @Override
        public E next() {
            this._lastElement = this._decorated.next();
            return this._lastElement;
        }

        @Override
        public void remove() {
            this._decorated.remove();
            AbstractEventSet.this.fireElementRemoved(this._lastElement);
        }
    }
}

