/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.javagimmicks.collections.event.AbstractEventCollection;
import net.sf.javagimmicks.collections.event.CollectionEvent;
import net.sf.javagimmicks.collections.event.EventCollectionListener;

public class ObservableEventCollection<E>
extends AbstractEventCollection<E> {
    private static final long serialVersionUID = -4055919694275882002L;
    protected transient List<EventCollectionListener<E>> _listeners;

    public ObservableEventCollection(Collection<E> decorated) {
        super(decorated);
    }

    public void addEventCollectionListener(EventCollectionListener<E> listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<EventCollectionListener<E>>();
        }
        this._listeners.add(listener);
    }

    public void removeEventCollectionListener(EventCollectionListener<E> listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    @Override
    protected void fireElementsAdded(Collection<? extends E> elements) {
        this.fireEvent(new CollectionEvent<E>(this, CollectionEvent.Type.ADDED, Collections.unmodifiableCollection(new ArrayList<E>(elements))));
    }

    @Override
    protected void fireElementRemoved(E element) {
        this.fireEvent(new CollectionEvent<E>(this, CollectionEvent.Type.REMOVED, Collections.singleton(element)));
    }

    private void fireEvent(CollectionEvent<E> event) {
        if (this._listeners == null) {
            return;
        }
        for (EventCollectionListener<E> listener : this._listeners) {
            listener.eventOccured(event);
        }
    }
}

