/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.javagimmicks.collections.event.AbstractEventList;
import net.sf.javagimmicks.collections.event.EventListListener;
import net.sf.javagimmicks.collections.event.ListEvent;

public class ObservableEventList<E>
extends AbstractEventList<E> {
    private static final long serialVersionUID = -6317396247733734848L;
    protected transient List<EventListListener<E>> _listeners;

    public ObservableEventList(List<E> decorated) {
        super(decorated);
    }

    public void addEventListListener(EventListListener<E> listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<EventListListener<E>>();
        }
        this._listeners.add(listener);
    }

    public void removeEventListListener(EventListListener<E> listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    @Override
    public ObservableEventList<E> subList(int fromIndex, int toIndex) {
        return new ObservableEventSubList(this, fromIndex, toIndex);
    }

    @Override
    protected void fireElementsAdded(int index, Collection<? extends E> elements) {
        ListEvent<? extends E> event = new ListEvent<E>(this, ListEvent.Type.ADDED, index, index + elements.size(), Collections.unmodifiableList(new ArrayList<E>(elements)));
        this.fireEvent(event);
    }

    @Override
    protected void fireElementUpdated(int index, E element, E newElement) {
        ListEvent<E> event = new ListEvent<E>(this, ListEvent.Type.UPDATED, index, index, Collections.singletonList(element), Collections.singletonList(newElement));
        this.fireEvent(event);
    }

    @Override
    protected void fireElementRemoved(int index, E element) {
        ListEvent<E> event = new ListEvent<E>(this, ListEvent.Type.REMOVED, index, index, Collections.singletonList(element));
        this.fireEvent(event);
    }

    private void fireEvent(ListEvent<E> event) {
        if (this._listeners == null) {
            return;
        }
        for (EventListListener<E> listener : this._listeners) {
            listener.eventOccured(event);
        }
    }

    protected static class ObservableEventSubList<E>
    extends ObservableEventList<E> {
        private static final long serialVersionUID = 1996968483016862598L;
        protected final ObservableEventList<E> _parent;
        protected final int _offset;

        protected ObservableEventSubList(ObservableEventList<E> parent, int fromIndex, int toIndex) {
            super(((ObservableEventList)parent)._decorated.subList(fromIndex, toIndex));
            this._parent = parent;
            this._offset = fromIndex;
        }

        @Override
        protected void fireElementsAdded(int index, Collection<? extends E> elements) {
            super.fireElementsAdded(index, elements);
            this._parent.fireElementsAdded(index + this._offset, elements);
        }

        @Override
        protected void fireElementRemoved(int index, E element) {
            super.fireElementRemoved(index, element);
            this._parent.fireElementRemoved(index + this._offset, element);
        }

        @Override
        protected void fireElementUpdated(int index, E element, E newElement) {
            super.fireElementUpdated(index, element, newElement);
            this._parent.fireElementUpdated(index + this._offset, element, newElement);
        }
    }
}

