/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.javagimmicks.collections.event.AbstractEventMap;
import net.sf.javagimmicks.collections.event.EventMapListener;
import net.sf.javagimmicks.collections.event.MapEvent;

public class ObservableEventMap<K, V>
extends AbstractEventMap<K, V> {
    private static final long serialVersionUID = 8006998141057065129L;
    protected transient List<EventMapListener<K, V>> _listeners;

    public ObservableEventMap(Map<K, V> decorated) {
        super(decorated);
    }

    public void addEventMapListener(EventMapListener<K, V> listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<EventMapListener<K, V>>();
        }
        this._listeners.add(listener);
    }

    public void removeEventMapListener(EventMapListener<K, V> listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    @Override
    protected void fireEntryAdded(K key, V value) {
        this.fireEvent(new MapEvent<K, V>(this, MapEvent.Type.ADDED, key, value));
    }

    @Override
    protected void fireEntryRemoved(K key, V value) {
        this.fireEvent(new MapEvent<K, V>(this, MapEvent.Type.REMOVED, key, value));
    }

    @Override
    protected void fireEntryUpdated(K key, V oldValue, V newValue) {
        this.fireEvent(new MapEvent<K, V>(this, MapEvent.Type.UPDATED, key, oldValue, newValue));
    }

    private void fireEvent(MapEvent<K, V> event) {
        if (this._listeners == null) {
            return;
        }
        for (EventMapListener<K, V> listener : this._listeners) {
            listener.eventOccured(event);
        }
    }
}

