/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import net.sf.javagimmicks.collections.event.AbstractEventNavigableMap;
import net.sf.javagimmicks.collections.event.EventNavigableMapListener;
import net.sf.javagimmicks.collections.event.NavigableMapEvent;

public class ObservableEventNavigableMap<K, V>
extends AbstractEventNavigableMap<K, V> {
    private static final long serialVersionUID = -4936595637793434597L;
    protected transient List<EventNavigableMapListener<K, V>> _listeners;

    public ObservableEventNavigableMap(NavigableMap<K, V> decorated) {
        super(decorated);
    }

    public void addEventNavigableMapListener(EventNavigableMapListener<K, V> listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<EventNavigableMapListener<K, V>>();
        }
        this._listeners.add(listener);
    }

    public void removeEventNavigableMapListener(EventNavigableMapListener<K, V> listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return super.descendingKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return super.descendingMap();
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return super.headMap(toKey, inclusive);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return super.navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return super.subMap(fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return super.tailMap(fromKey, inclusive);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return super.headMap(toKey);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return super.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return super.tailMap(fromKey);
    }

    @Override
    protected void fireEntryAdded(K key, V value) {
        this.fireEvent(new NavigableMapEvent<K, V>(this, NavigableMapEvent.Type.ADDED, key, value));
    }

    @Override
    protected void fireEntryRemoved(K key, V value) {
        this.fireEvent(new NavigableMapEvent<K, V>(this, NavigableMapEvent.Type.REMOVED, key, value));
    }

    @Override
    protected void fireEntryUpdated(K key, V oldValue, V newValue) {
        this.fireEvent(new NavigableMapEvent<K, V>(this, NavigableMapEvent.Type.UPDATED, key, oldValue, newValue));
    }

    private void fireEvent(NavigableMapEvent<K, V> event) {
        if (this._listeners == null) {
            return;
        }
        for (EventNavigableMapListener<K, V> listener : this._listeners) {
            listener.eventOccured(event);
        }
    }

    protected static class ObservableEventSubNavigableMap<K, V>
    extends ObservableEventNavigableMap<K, V> {
        private static final long serialVersionUID = -863678987488740776L;
        protected final ObservableEventNavigableMap<K, V> _parent;

        protected ObservableEventSubNavigableMap(ObservableEventNavigableMap<K, V> parent, NavigableMap<K, V> decorated) {
            super(decorated);
            this._parent = parent;
        }

        @Override
        protected void fireEntryAdded(K key, V value) {
            super.fireEntryAdded(key, value);
            this._parent.fireEntryAdded(key, value);
        }

        @Override
        protected void fireEntryRemoved(K key, V value) {
            super.fireEntryRemoved(key, value);
            this._parent.fireEntryRemoved(key, value);
        }

        @Override
        protected void fireEntryUpdated(K key, V oldValue, V newValue) {
            super.fireEntryUpdated(key, oldValue, newValue);
            this._parent.fireEntryUpdated(key, oldValue, newValue);
        }
    }
}

