/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.javagimmicks.collections.event.AbstractEventSet;
import net.sf.javagimmicks.collections.event.EventSetListener;
import net.sf.javagimmicks.collections.event.SetEvent;

public class ObservableEventSet<E>
extends AbstractEventSet<E> {
    private static final long serialVersionUID = 4799365684601532982L;
    protected transient List<EventSetListener<E>> _listeners;

    public ObservableEventSet(Set<E> decorated) {
        super(decorated);
    }

    public void addEventSetListener(EventSetListener<E> listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<EventSetListener<E>>();
        }
        this._listeners.add(listener);
    }

    public void removeEventSetListener(EventSetListener<E> listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    @Override
    protected void fireElementAdded(E element) {
        this.fireEvent(new SetEvent<E>(this, SetEvent.Type.ADDED, element));
    }

    @Override
    protected void fireElementReadded(E element) {
        this.fireEvent(new SetEvent<E>(this, SetEvent.Type.READDED, element));
    }

    @Override
    protected void fireElementRemoved(E element) {
        this.fireEvent(new SetEvent<E>(this, SetEvent.Type.REMOVED, element));
    }

    private void fireEvent(SetEvent<E> event) {
        if (this._listeners == null) {
            return;
        }
        for (EventSetListener<E> listener : this._listeners) {
            listener.eventOccured(event);
        }
    }
}

