/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.event;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import net.sf.javagimmicks.collections.event.AbstractEventSortedMap;
import net.sf.javagimmicks.collections.event.EventSortedMapListener;
import net.sf.javagimmicks.collections.event.SortedMapEvent;

public class ObservableEventSortedMap<K, V>
extends AbstractEventSortedMap<K, V> {
    private static final long serialVersionUID = -4377528012758388630L;
    protected transient List<EventSortedMapListener<K, V>> _listeners;

    public ObservableEventSortedMap(SortedMap<K, V> decorated) {
        super(decorated);
    }

    public void addEventSortedMapListener(EventSortedMapListener<K, V> listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<EventSortedMapListener<K, V>>();
        }
        this._listeners.add(listener);
    }

    public void removeEventSortedMapListener(EventSortedMapListener<K, V> listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    @Override
    public ObservableEventSortedMap<K, V> headMap(K toKey) {
        return new ObservableEventSubSortedMap(this, this.getDecorated().headMap(toKey));
    }

    @Override
    public ObservableEventSortedMap<K, V> subMap(K fromKey, K toKey) {
        return new ObservableEventSubSortedMap(this, this.getDecorated().subMap(fromKey, toKey));
    }

    @Override
    public ObservableEventSortedMap<K, V> tailMap(K fromKey) {
        return new ObservableEventSubSortedMap(this, this.getDecorated().tailMap(fromKey));
    }

    @Override
    protected void fireEntryAdded(K key, V value) {
        this.fireEvent(new SortedMapEvent<K, V>(this, SortedMapEvent.Type.ADDED, key, value));
    }

    @Override
    protected void fireEntryRemoved(K key, V value) {
        this.fireEvent(new SortedMapEvent<K, V>(this, SortedMapEvent.Type.REMOVED, key, value));
    }

    @Override
    protected void fireEntryUpdated(K key, V oldValue, V newValue) {
        this.fireEvent(new SortedMapEvent<K, V>(this, SortedMapEvent.Type.UPDATED, key, oldValue, newValue));
    }

    private void fireEvent(SortedMapEvent<K, V> event) {
        if (this._listeners == null) {
            return;
        }
        for (EventSortedMapListener<K, V> listener : this._listeners) {
            listener.eventOccured(event);
        }
    }

    protected static class ObservableEventSubSortedMap<K, V>
    extends ObservableEventSortedMap<K, V> {
        private static final long serialVersionUID = 8431554623263356463L;
        protected final ObservableEventSortedMap<K, V> _parent;

        protected ObservableEventSubSortedMap(ObservableEventSortedMap<K, V> parent, SortedMap<K, V> decorated) {
            super(decorated);
            this._parent = parent;
        }

        @Override
        protected void fireEntryAdded(K key, V value) {
            super.fireEntryAdded(key, value);
            this._parent.fireEntryAdded(key, value);
        }

        @Override
        protected void fireEntryRemoved(K key, V value) {
            super.fireEntryRemoved(key, value);
            this._parent.fireEntryRemoved(key, value);
        }

        @Override
        protected void fireEntryUpdated(K key, V oldValue, V newValue) {
            super.fireEntryUpdated(key, oldValue, newValue);
            this._parent.fireEntryUpdated(key, oldValue, newValue);
        }
    }
}

