/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.filter;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.javagimmicks.collections.event.AbstractEventList;
import net.sf.javagimmicks.lang.Filter;

public class FilterList<E>
extends AbstractEventList<E> {
    private static final long serialVersionUID = 8662426678003785337L;
    protected final List<Reference<FilteredList>> _filteredLists = new ArrayList<Reference<FilteredList>>();
    protected boolean _childrenReadOnly;

    public FilterList(List<E> internalList, boolean childrenReadOnly) {
        super(internalList);
        this.setChildrenReadOnly(childrenReadOnly);
    }

    public FilterList(List<E> internalList) {
        this(internalList, true);
    }

    public FilterList(boolean childrenReadOnly) {
        this(new ArrayList(), childrenReadOnly);
    }

    public FilterList() {
        this(true);
    }

    public List<E> createFilteredList(Filter<E> filter) {
        FilteredList result = new FilteredList(filter);
        ListIterator iterElements = this.getDecorated().listIterator();
        while (iterElements.hasNext()) {
            if (!filter.accepts(iterElements.next())) continue;
            result._realIndeces.add(iterElements.previousIndex());
        }
        this._filteredLists.add(new WeakReference<FilteredList>(result));
        return result;
    }

    public boolean isChildrenReadOnly() {
        return this._childrenReadOnly;
    }

    public void setChildrenReadOnly(boolean childrenReadOnly) {
        this._childrenReadOnly = childrenReadOnly;
    }

    public List<FilteredList> getActiveFilteredLists() {
        return Collections.unmodifiableList(this.getAliveFilterLists());
    }

    @Override
    protected void fireElementsAdded(int index, Collection<? extends E> elements) {
        for (FilteredList filteredList : this.getAliveFilterLists()) {
            for (E element : elements) {
                this.doAdd(filteredList, index, filteredList._filter.accepts(element));
            }
        }
    }

    @Override
    protected void fireElementRemoved(int index, E element) {
        for (FilteredList filteredList : this.getAliveFilterLists()) {
            this.doRemove(filteredList, index);
        }
    }

    @Override
    protected void fireElementUpdated(int index, E oldElement, E newElement) {
        for (FilteredList filteredList : this.getAliveFilterLists()) {
            boolean acceptsNew;
            boolean acceptsOld = filteredList._filter.accepts(oldElement);
            if (acceptsOld == (acceptsNew = filteredList._filter.accepts(newElement))) continue;
            int realIndex = this.findStartIndex(filteredList, index);
            if (acceptsOld) {
                filteredList._realIndeces.remove(realIndex);
                continue;
            }
            filteredList._realIndeces.add(realIndex, index);
        }
    }

    private int findStartIndex(FilteredList filteredList, int index) {
        ListIterator<Integer> iterIndex = filteredList._realIndeces.listIterator();
        while (iterIndex.hasNext()) {
            int realIndex = iterIndex.next();
            if (realIndex < index) continue;
            return iterIndex.previousIndex();
        }
        return -1;
    }

    private List<FilteredList> getAliveFilterLists() {
        ArrayList<FilteredList> result = new ArrayList<FilteredList>(this._filteredLists.size());
        Iterator<Reference<FilteredList>> iter = this._filteredLists.iterator();
        while (iter.hasNext()) {
            FilteredList filteredList = iter.next().get();
            if (filteredList == null) {
                iter.remove();
                continue;
            }
            result.add(filteredList);
        }
        return result;
    }

    private void doAdd(FilteredList filteredList, int index, boolean accepts) {
        int startIndex = this.findStartIndex(filteredList, index);
        if (startIndex >= 0) {
            ListIterator<Integer> iterIndex = filteredList._realIndeces.listIterator(startIndex);
            while (iterIndex.hasNext()) {
                iterIndex.set(iterIndex.next() + 1);
            }
        }
        if (accepts) {
            if (startIndex == -1) {
                filteredList._realIndeces.add(index);
            } else {
                filteredList._realIndeces.add(startIndex, index);
            }
        }
    }

    private void doRemove(FilteredList filteredList, int index) {
        int startIndex = this.findStartIndex(filteredList, index);
        if (startIndex >= 0) {
            ListIterator<Integer> iterIndex = filteredList._realIndeces.listIterator(startIndex);
            while (iterIndex.hasNext()) {
                int realIndex = iterIndex.next();
                if (realIndex == index) {
                    iterIndex.remove();
                    continue;
                }
                iterIndex.set(realIndex - 1);
            }
        }
    }

    public class FilteredList
    extends AbstractList<E> {
        protected final List<Integer> _realIndeces = new ArrayList<Integer>();
        protected final Filter<E> _filter;

        protected FilteredList(Filter<E> filter) {
            this._filter = filter;
        }

        public FilterList<E> getFilterList() {
            return FilterList.this;
        }

        @Override
        public boolean add(E e) {
            if (FilterList.this._childrenReadOnly) {
                throw new UnsupportedOperationException();
            }
            if (!this._filter.accepts(e)) {
                String string = "Cannot add an element to a " + this.getClass().getSimpleName() + " which is not accepted by the filter!";
                throw new IllegalArgumentException(string);
            }
            FilterList.this.add(e);
            return true;
        }

        @Override
        public E set(int index, E element) {
            if (FilterList.this._childrenReadOnly) {
                throw new UnsupportedOperationException();
            }
            if (!this._filter.accepts(element)) {
                String string = "Cannot set an element in a " + this.getClass().getSimpleName() + " which is not accepted by the filter!";
                throw new IllegalArgumentException(string);
            }
            Object result = FilterList.this.set(this.getRealIndex(index), element);
            return result;
        }

        @Override
        public E get(int index) {
            return FilterList.this.get(this.getRealIndex(index));
        }

        @Override
        public int size() {
            return this._realIndeces.size();
        }

        @Override
        public E remove(int index) {
            return FilterList.this.remove(this.getRealIndex(index));
        }

        private int getRealIndex(int index) {
            return this._realIndeces.get(index);
        }
    }
}

