/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.mapping;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.collections.mapping.DefaultMapping;
import net.sf.javagimmicks.collections.mapping.Mappings;

public abstract class AbstractMappings<L, R>
implements Mappings<L, R> {
    private static final long serialVersionUID = -8390090502631423671L;

    @Override
    public Set<Mappings.Mapping<L, R>> getMappingSet() {
        return new MappingSet(this.getLeftMap().entrySet());
    }

    @Override
    public Iterator<Mappings.Mapping<L, R>> iterator() {
        return this.getMappingSet().iterator();
    }

    @Override
    public Mappings<R, L> getInverseMappings() {
        return new InverseMappings(this);
    }

    @Override
    public Set<R> getRight(L left) {
        return this.getLeftMap().get(left);
    }

    @Override
    public Set<L> getLeft(R right) {
        return this.getRightMap().get(right);
    }

    @Override
    public boolean put(L left, R right) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putLeft(R right, Collection<? extends L> c) {
        boolean result = false;
        for (L left : c) {
            result |= this.put(left, right);
        }
        return result;
    }

    @Override
    public boolean putRight(L left, Collection<? extends R> c) {
        boolean result = false;
        for (R right : c) {
            result |= this.put(left, right);
        }
        return result;
    }

    @Override
    public boolean remove(L left, R right) {
        Set<R> mappedValuesLeft = this.getRight(left);
        return mappedValuesLeft != null ? mappedValuesLeft.remove(right) : false;
    }

    @Override
    public boolean containsLeft(L left) {
        return this.getLeftMap().containsKey(left);
    }

    @Override
    public boolean containsRight(R right) {
        return this.getRightMap().containsKey(right);
    }

    @Override
    public boolean contains(L left, R right) {
        Set<R> rightSet = this.getRight(left);
        return rightSet != null && rightSet.contains(right);
    }

    @Override
    public Set<R> removeRight(L left) {
        return this.getLeftMap().remove(left);
    }

    @Override
    public Set<L> removeLeft(R right) {
        return this.getRightMap().remove(right);
    }

    @Override
    public void clear() {
        this.getLeftMap().clear();
    }

    @Override
    public int size() {
        return this.getMappingSet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMappingSet().isEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mappings)) {
            return false;
        }
        Mappings other = (Mappings)obj;
        return ((Object)this.getMappingSet()).equals(other.getMappingSet());
    }

    public String toString() {
        return this.getLeftMap() + " | " + this.getRightMap();
    }

    public static class InverseMappings<L, R>
    extends AbstractMappings<R, L> {
        private static final long serialVersionUID = -4525522714547396946L;
        protected final Mappings<L, R> _partner;

        public InverseMappings(Mappings<L, R> partner) {
            this._partner = partner;
        }

        @Override
        public Mappings<L, R> getInverseMappings() {
            return this._partner;
        }

        @Override
        public boolean put(R left, L right) {
            return this._partner.put(right, left);
        }

        @Override
        public void clear() {
            this._partner.clear();
        }

        @Override
        public Map<R, Set<L>> getLeftMap() {
            return this._partner.getRightMap();
        }

        @Override
        public Set<L> getRight(R left) {
            return this._partner.getLeft(left);
        }

        @Override
        public Set<R> getLeft(L right) {
            return this._partner.getRight(right);
        }

        @Override
        public Map<L, Set<R>> getRightMap() {
            return this._partner.getLeftMap();
        }

        @Override
        public boolean remove(R left, L right) {
            return this._partner.remove(right, left);
        }

        @Override
        public Set<L> removeRight(R left) {
            return this._partner.removeLeft(left);
        }

        @Override
        public Set<R> removeLeft(L right) {
            return this._partner.removeRight(right);
        }
    }

    protected static class MappingIterator<L, R>
    implements Iterator<Mappings.Mapping<L, R>> {
        protected final Iterator<Map.Entry<L, Set<R>>> _entryIterator;
        protected Iterator<R> _valueItertor;
        protected Map.Entry<L, Set<R>> _currentEntry;
        protected R _currentValue;

        protected MappingIterator(Iterator<Map.Entry<L, Set<R>>> entryIterator) {
            this._entryIterator = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this._valueItertor != null && this._valueItertor.hasNext() || this._entryIterator.hasNext();
        }

        @Override
        public Mappings.Mapping<L, R> next() {
            this.moveNext();
            return new DefaultMapping<L, R>(this._currentEntry.getKey(), this._currentValue);
        }

        @Override
        public void remove() {
            this._valueItertor.remove();
            if (this._currentEntry.getValue().isEmpty()) {
                this._entryIterator.remove();
            }
        }

        private void moveNext() {
            if (this._valueItertor == null || !this._valueItertor.hasNext()) {
                this._currentEntry = this._entryIterator.next();
                this._valueItertor = this._currentEntry.getValue().iterator();
            }
            this._currentValue = this._valueItertor.next();
        }
    }

    protected static class MappingSet<L, R>
    extends AbstractSet<Mappings.Mapping<L, R>> {
        protected final Set<Map.Entry<L, Set<R>>> _entries;

        public MappingSet(Set<Map.Entry<L, Set<R>>> entries) {
            this._entries = entries;
        }

        @Override
        public Iterator<Mappings.Mapping<L, R>> iterator() {
            return new MappingIterator<L, R>(this._entries.iterator());
        }

        @Override
        public int size() {
            int size = 0;
            for (Map.Entry<L, Set<R>> entry : this._entries) {
                size += entry.getValue().size();
            }
            return size;
        }
    }
}

