/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.mapping;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.collections.mapping.ValueMappings;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils;
import net.sf.javagimmicks.lang.LangUtils;

public abstract class AbstractValueMappings<L, R, E>
implements ValueMappings<L, R, E> {
    private static final long serialVersionUID = 3350171311023033933L;
    protected final Transformer<ValueMappings.Mapping<L, R, E>, E> VALUE_TRANSFORMER = new Transformer<ValueMappings.Mapping<L, R, E>, E>(){

        @Override
        public E transform(ValueMappings.Mapping<L, R, E> source) {
            return source.getValue();
        }
    };

    @Override
    public Set<ValueMappings.Mapping<L, R, E>> getMappingSet() {
        return new MappingSet(this.getLeftOuterMap().entrySet());
    }

    @Override
    public Iterator<ValueMappings.Mapping<L, R, E>> iterator() {
        return this.getMappingSet().iterator();
    }

    @Override
    public ValueMappings<R, L, E> getInverseMappings() {
        return new InverseMappings(this);
    }

    @Override
    public Map<R, E> getRightInnerMap(L left) {
        return this.getLeftOuterMap().get(left);
    }

    @Override
    public Map<L, E> getLeftInnerMap(R right) {
        return this.getRightOuterMap().get(right);
    }

    @Override
    public E put(L left, R right, E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putLeft(R right, Map<? extends L, ? extends E> c) {
        for (Map.Entry<L, E> left : c.entrySet()) {
            this.put(left.getKey(), right, left.getValue());
        }
    }

    @Override
    public void putRight(L left, Map<? extends R, ? extends E> c) {
        for (Map.Entry<R, E> right : c.entrySet()) {
            this.put(left, right.getKey(), right.getValue());
        }
    }

    @Override
    public E get(L left, R right) {
        Map<R, E> rightInnerMap = this.getRightInnerMap(left);
        return rightInnerMap != null ? (E)rightInnerMap.get(right) : null;
    }

    @Override
    public E remove(L left, R right) {
        Map<R, E> mappedValuesLeft = this.getRightInnerMap(left);
        return mappedValuesLeft != null ? (E)mappedValuesLeft.remove(right) : null;
    }

    @Override
    public Collection<E> getValues() {
        return TransformerUtils.decorate(this.getMappingSet(), this.VALUE_TRANSFORMER);
    }

    @Override
    public boolean containsLeft(L left) {
        return this.getLeftOuterMap().containsKey(left);
    }

    @Override
    public boolean containsRight(R right) {
        return this.getRightOuterMap().containsKey(right);
    }

    @Override
    public boolean containsMapping(L left, R right) {
        Map<R, E> rightInnerMap = this.getRightInnerMap(left);
        return rightInnerMap != null && rightInnerMap.containsKey(right);
    }

    @Override
    public Map<R, E> removeRight(L left) {
        return this.getLeftOuterMap().remove(left);
    }

    @Override
    public Map<L, E> removeLeft(R right) {
        return this.getRightOuterMap().remove(right);
    }

    @Override
    public void clear() {
        this.getLeftOuterMap().clear();
    }

    @Override
    public int size() {
        return this.getMappingSet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMappingSet().isEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueMappings)) {
            return false;
        }
        ValueMappings other = (ValueMappings)obj;
        return ((Object)this.getMappingSet()).equals(other.getMappingSet());
    }

    public String toString() {
        return this.getLeftOuterMap() + " | " + this.getRightOuterMap();
    }

    public static class InverseMappings<L, R, E>
    extends AbstractValueMappings<R, L, E> {
        private static final long serialVersionUID = 6830247408926542348L;
        protected final ValueMappings<L, R, E> _partner;

        public InverseMappings(ValueMappings<L, R, E> partner) {
            this._partner = partner;
        }

        @Override
        public ValueMappings<L, R, E> getInverseMappings() {
            return this._partner;
        }

        @Override
        public E put(R left, L right, E value) {
            return this._partner.put(right, left, value);
        }

        @Override
        public void clear() {
            this._partner.clear();
        }

        @Override
        public Map<R, Map<L, E>> getLeftOuterMap() {
            return this._partner.getRightOuterMap();
        }

        @Override
        public Map<L, E> getRightInnerMap(R left) {
            return this._partner.getLeftInnerMap(left);
        }

        @Override
        public Map<R, E> getLeftInnerMap(L right) {
            return this._partner.getRightInnerMap(right);
        }

        @Override
        public Map<L, Map<R, E>> getRightOuterMap() {
            return this._partner.getLeftOuterMap();
        }

        @Override
        public E remove(R left, L right) {
            return this._partner.remove(right, left);
        }

        @Override
        public Map<L, E> removeRight(R left) {
            return this._partner.removeLeft(left);
        }

        @Override
        public Map<R, E> removeLeft(L right) {
            return this._partner.removeRight(right);
        }
    }

    protected static class MappingIterator<L, R, E>
    implements Iterator<ValueMappings.Mapping<L, R, E>> {
        protected final Iterator<Map.Entry<L, Map<R, E>>> _entryIterator;
        protected Iterator<Map.Entry<R, E>> _valueItertor;
        protected Map.Entry<L, Map<R, E>> _currentEntry;
        protected Map.Entry<R, E> _currentValue;

        protected MappingIterator(Iterator<Map.Entry<L, Map<R, E>>> entryIterator) {
            this._entryIterator = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this._valueItertor != null && this._valueItertor.hasNext() || this._entryIterator.hasNext();
        }

        @Override
        public ValueMappings.Mapping<L, R, E> next() {
            this.moveNext();
            final L left = this._currentEntry.getKey();
            final R right = this._currentValue.getKey();
            final E value = this._currentValue.getValue();
            AbstractMapping mapping = new AbstractMapping<L, R, E>(){
                private static final long serialVersionUID = -893342873662381319L;

                @Override
                public L getLeft() {
                    return left;
                }

                @Override
                public R getRight() {
                    return right;
                }

                @Override
                public E getValue() {
                    return value;
                }
            };
            return mapping;
        }

        @Override
        public void remove() {
            this._valueItertor.remove();
            if (this._currentEntry.getValue().isEmpty()) {
                this._entryIterator.remove();
            }
        }

        private void moveNext() {
            if (this._valueItertor == null || !this._valueItertor.hasNext()) {
                this._currentEntry = this._entryIterator.next();
                this._valueItertor = this._currentEntry.getValue().entrySet().iterator();
            }
            this._currentValue = this._valueItertor.next();
        }
    }

    protected static class MappingSet<L, R, E>
    extends AbstractSet<ValueMappings.Mapping<L, R, E>> {
        protected final Set<Map.Entry<L, Map<R, E>>> _entries;

        public MappingSet(Set<Map.Entry<L, Map<R, E>>> entries) {
            this._entries = entries;
        }

        @Override
        public Iterator<ValueMappings.Mapping<L, R, E>> iterator() {
            return new MappingIterator<L, R, E>(this._entries.iterator());
        }

        @Override
        public int size() {
            int size = 0;
            for (Map.Entry<L, Map<R, E>> entry : this._entries) {
                size += entry.getValue().size();
            }
            return size;
        }
    }

    public static abstract class AbstractMapping<L, R, E>
    implements ValueMappings.Mapping<L, R, E> {
        private static final long serialVersionUID = -293860609319776316L;

        @Override
        public ValueMappings.Mapping<R, L, E> getInverseMapping() {
            return new AbstractMapping<R, L, E>(){
                private static final long serialVersionUID = -2436668735196156472L;

                @Override
                public ValueMappings.Mapping<L, R, E> getInverseMapping() {
                    return AbstractMapping.this;
                }

                @Override
                public R getLeft() {
                    return AbstractMapping.this.getRight();
                }

                @Override
                public L getRight() {
                    return AbstractMapping.this.getLeft();
                }

                @Override
                public E getValue() {
                    return AbstractMapping.this.getValue();
                }
            };
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ValueMappings.Mapping)) {
                return false;
            }
            ValueMappings.Mapping other = (ValueMappings.Mapping)obj;
            return this.getLeft().equals(other.getLeft()) && this.getRight().equals(other.getRight()) && LangUtils.equalsNullSafe(this.getValue(), other.getValue());
        }

        public int hashCode() {
            return 5 * this.getLeft().hashCode() + 7 * this.getRight().hashCode() + 3872123;
        }

        public String toString() {
            return "[" + this.getLeft() + "/" + this.getRight() + ": " + this.getValue() + "]";
        }
    }
}

