/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.mapping;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.javagimmicks.collections.event.AbstractEventSet;
import net.sf.javagimmicks.collections.mapping.AbstractMappings;

public class DualMapMappings<L, R>
extends AbstractMappings<L, R> {
    private static final long serialVersionUID = 6670241289938071773L;
    protected final ValueMap<L, R> _left;

    public static <L, R> DualMapMappings<L, R> createHashHashInstance() {
        return new DualMapMappings<L, R>(StoreType.HASH.getFactory(), StoreType.HASH.getFactory());
    }

    public static <L, R> DualMapMappings<L, R> createHashTreeInstance() {
        return new DualMapMappings<L, R>(StoreType.HASH.getFactory(), StoreType.TREE.getFactory());
    }

    public static <L, R> DualMapMappings<L, R> createTreeHashInstance() {
        return new DualMapMappings<L, R>(StoreType.TREE.getFactory(), StoreType.HASH.getFactory());
    }

    public static <L, R> DualMapMappings<L, R> createTreeTreeInstance() {
        return new DualMapMappings<L, R>(StoreType.TREE.getFactory(), StoreType.TREE.getFactory());
    }

    protected DualMapMappings(StoreFactory leftFactory, StoreFactory rightFactory) {
        this._left = new ValueMap(leftFactory, rightFactory);
    }

    @Override
    public boolean put(L left, R right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Neither left nor right value may be null!");
        }
        ValueSet valueSet = (ValueSet)this._left.get(left);
        if (valueSet == null) {
            this._left.put(left, Collections.singleton(right));
            return true;
        }
        return valueSet.add(right);
    }

    @Override
    public Map<L, Set<R>> getLeftMap() {
        return this._left;
    }

    @Override
    public Map<R, Set<L>> getRightMap() {
        return this._left._partnerMap;
    }

    public static enum StoreType {
        HASH(new StoreFactory(){
            private static final long serialVersionUID = 5873569465040591757L;

            @Override
            public <K, V> Map<K, V> createMap() {
                return new HashMap();
            }

            @Override
            public <T> Set<T> createSet() {
                return new HashSet();
            }
        }),
        TREE(new StoreFactory(){
            private static final long serialVersionUID = 4635243875231393315L;

            @Override
            public <K, V> Map<K, V> createMap() {
                return new TreeMap();
            }

            @Override
            public <T> Set<T> createSet() {
                return new TreeSet();
            }
        });

        private final StoreFactory _factory;

        private StoreType(StoreFactory factory) {
            this._factory = factory;
        }

        public StoreFactory getFactory() {
            return this._factory;
        }
    }

    protected static interface StoreFactory
    extends Serializable {
        public <T> Set<T> createSet();

        public <K, V> Map<K, V> createMap();
    }

    protected static class ValueSet<L, R>
    extends AbstractEventSet<R> {
        private static final long serialVersionUID = -8381132398717092121L;
        protected final StoreFactory _factory;
        protected final L _left;
        protected final ValueMap<R, L> _otherMap;
        protected boolean _detached = false;
        private boolean _internalFlag = false;

        protected ValueSet(Set<R> decorated, StoreFactory factory, L left, ValueMap<R, L> otherMap) {
            super(decorated);
            this._factory = factory;
            this._left = left;
            this._otherMap = otherMap;
        }

        @Override
        public boolean add(R e) {
            if (this._detached) {
                throw new IllegalStateException("Value set is detached! No further adding possible!");
            }
            return super.add(e);
        }

        @Override
        public void clear() {
            super.clear();
        }

        protected void clearForReuse() {
            this._internalFlag = true;
            this.clear();
            this._internalFlag = false;
        }

        @Override
        protected void fireElementAdded(R element) {
            Map otherInternalMap = this._otherMap._internal;
            ValueSet<Object, Object> otherSet = otherInternalMap.get(element);
            if (otherSet == null) {
                Set otherDecoratedSet = this._factory.createSet();
                otherSet = new ValueSet(otherDecoratedSet, this._otherMap._factory, element, this._otherMap._partnerMap);
                otherInternalMap.put(element, otherSet);
            }
            otherSet.getDecorated().add(this._left);
        }

        @Override
        protected void fireElementRemoved(R element) {
            Map otherInternalMap = this._otherMap._internal;
            ValueSet otherSet = otherInternalMap.get(element);
            otherSet.getDecorated().remove(this._left);
            if (otherSet.isEmpty()) {
                otherSet._detached = true;
                otherInternalMap.remove(element);
            }
            if (this.isEmpty() && !this._internalFlag) {
                this._detached = true;
                this._otherMap._partnerMap._internal.remove(this._left);
            }
        }

        @Override
        protected void fireElementReadded(R element) {
        }
    }

    protected static class ValueMapEntry<L, R>
    implements Map.Entry<L, Set<R>> {
        private final ValueMap<L, R> _parentMap;
        private final Map.Entry<L, ValueSet<L, R>> _internalEntry;

        protected ValueMapEntry(ValueMap<L, R> parentMap, Map.Entry<L, ValueSet<L, R>> nextEntry) {
            this._parentMap = parentMap;
            this._internalEntry = nextEntry;
        }

        @Override
        public L getKey() {
            return this._internalEntry.getKey();
        }

        @Override
        public Set<R> getValue() {
            return this._internalEntry.getValue();
        }

        @Override
        public Set<R> setValue(Set<R> value) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("May not explicitly set null or an empty set as entry value!");
            }
            ValueSet<L, R> valueSet = this._internalEntry.getValue();
            Set result = this._parentMap._partnerMap._factory.createSet();
            result.addAll(valueSet.getDecorated());
            valueSet.clearForReuse();
            valueSet.addAll(value);
            return result;
        }

        public String toString() {
            return this.getKey() + "=[" + this.getValue() + "]";
        }
    }

    protected static class ValueMapEntrySetIterator<L, R>
    implements Iterator<Map.Entry<L, Set<R>>> {
        private final ValueMap<L, R> _parentMap;
        private final Iterator<Map.Entry<L, ValueSet<L, R>>> _internalIterator;
        private Map.Entry<L, ValueSet<L, R>> _last;

        protected ValueMapEntrySetIterator(ValueMap<L, R> parentMap, Iterator<Map.Entry<L, ValueSet<L, R>>> internalIterator) {
            this._parentMap = parentMap;
            this._internalIterator = internalIterator;
        }

        @Override
        public boolean hasNext() {
            return this._internalIterator.hasNext();
        }

        @Override
        public Map.Entry<L, Set<R>> next() {
            Map.Entry<L, ValueSet<L, R>> nextEntry = this._internalIterator.next();
            this._last = nextEntry;
            return new ValueMapEntry<L, R>(this._parentMap, nextEntry);
        }

        @Override
        public void remove() {
            this._internalIterator.remove();
            ValueSet<L, R> valueSet = this._last.getValue();
            valueSet.clear();
        }
    }

    protected static class ValueMapEntrySet<L, R>
    extends AbstractSet<Map.Entry<L, Set<R>>> {
        private final ValueMap<L, R> _parentMap;

        protected ValueMapEntrySet(ValueMap<L, R> parentMap) {
            this._parentMap = parentMap;
        }

        @Override
        public Iterator<Map.Entry<L, Set<R>>> iterator() {
            return new ValueMapEntrySetIterator<L, R>(this._parentMap, this._parentMap._internal.entrySet().iterator());
        }

        @Override
        public int size() {
            return this._parentMap._internal.size();
        }
    }

    protected static class ValueMap<L, R>
    extends AbstractMap<L, Set<R>>
    implements Serializable {
        private static final long serialVersionUID = 3088051603731444631L;
        protected final StoreFactory _factory;
        protected final Map<L, ValueSet<L, R>> _internal;
        protected final ValueMap<R, L> _partnerMap;

        protected ValueMap(StoreFactory factory, ValueMap<R, L> partnerMap) {
            this._factory = factory;
            this._internal = factory.createMap();
            this._partnerMap = partnerMap;
        }

        protected ValueMap(StoreFactory leftFactory, StoreFactory rightFactory) {
            this._factory = leftFactory;
            this._internal = leftFactory.createMap();
            this._partnerMap = new ValueMap<L, R>(rightFactory, this);
        }

        @Override
        public Set<Map.Entry<L, Set<R>>> entrySet() {
            return new ValueMapEntrySet(this);
        }

        public Iterator<Map.Entry<L, Set<R>>> iterator() {
            return this.entrySet().iterator();
        }

        @Override
        public Set<R> put(L key, Set<R> value) {
            Set result;
            if (key == null) {
                throw new IllegalArgumentException("Key mustn't be null!");
            }
            if (value == null || value.isEmpty()) {
                ValueSet<L, R> valueSet = this._internal.remove(key);
                if (valueSet == null) {
                    return null;
                }
                Set result2 = this._partnerMap._factory.createSet();
                result2.addAll(valueSet.getDecorated());
                valueSet.clear();
                return result2;
            }
            if (value.contains(null)) {
                throw new IllegalArgumentException("The value-set may not contain null!");
            }
            ValueSet<L, Object> valueSet = this._internal.get(key);
            if (valueSet == null) {
                result = null;
                Set decorated = this._partnerMap._factory.createSet();
                valueSet = new ValueSet(decorated, this._factory, key, this._partnerMap);
                this._internal.put(key, valueSet);
            } else {
                result = this._partnerMap._factory.createSet();
                result.addAll(valueSet.getDecorated());
                valueSet.clearForReuse();
            }
            valueSet.addAll(value);
            return result;
        }

        @Override
        public Set<R> remove(Object key) {
            ValueSet<L, R> valueSet = this._internal.remove(key);
            if (valueSet == null) {
                return null;
            }
            Set result = this._partnerMap._factory.createSet();
            result.addAll(valueSet);
            valueSet.clear();
            return result;
        }

        @Override
        public Set<R> get(Object key) {
            return this._internal.get(key);
        }
    }
}

