/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.mapping;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.javagimmicks.collections.event.AbstractEventMap;
import net.sf.javagimmicks.collections.mapping.AbstractValueMappings;

public class DualMapValueMappings<L, R, E>
extends AbstractValueMappings<L, R, E> {
    private static final long serialVersionUID = 7852860994833056710L;
    protected final OuterMap<L, R, E> _left;

    public static <L, R, E> DualMapValueMappings<L, R, E> createHashHashInstance() {
        return new DualMapValueMappings<L, R, E>(StoreType.HASH.getFactory(), StoreType.HASH.getFactory());
    }

    public static <L, R, E> DualMapValueMappings<L, R, E> createHashTreeInstance() {
        return new DualMapValueMappings<L, R, E>(StoreType.HASH.getFactory(), StoreType.TREE.getFactory());
    }

    public static <L, R, E> DualMapValueMappings<L, R, E> createTreeHashInstance() {
        return new DualMapValueMappings<L, R, E>(StoreType.TREE.getFactory(), StoreType.HASH.getFactory());
    }

    public static <L, R, E> DualMapValueMappings<L, R, E> createTreeTreeInstance() {
        return new DualMapValueMappings<L, R, E>(StoreType.TREE.getFactory(), StoreType.TREE.getFactory());
    }

    protected DualMapValueMappings(StoreFactory leftFactory, StoreFactory rightFactory) {
        this._left = new OuterMap(leftFactory, rightFactory);
    }

    @Override
    public E put(L left, R right, E value) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Neither left nor right value may be null!");
        }
        InnerMap innerMap = (InnerMap)this._left.get(left);
        if (innerMap == null) {
            this._left.put(left, Collections.singletonMap(right, value));
            return null;
        }
        return innerMap.put(right, value);
    }

    @Override
    public Map<L, Map<R, E>> getLeftOuterMap() {
        return this._left;
    }

    @Override
    public Map<R, Map<L, E>> getRightOuterMap() {
        return this._left._partnerMap;
    }

    public static enum StoreType {
        HASH(new StoreFactory(){
            private static final long serialVersionUID = 2570752436161022580L;

            @Override
            public <K, V> Map<K, V> createMap() {
                return new HashMap();
            }
        }),
        TREE(new StoreFactory(){
            private static final long serialVersionUID = -2301586648259664423L;

            @Override
            public <K, V> Map<K, V> createMap() {
                return new TreeMap();
            }
        });

        private final StoreFactory _factory;

        private StoreType(StoreFactory factory) {
            this._factory = factory;
        }

        public StoreFactory getFactory() {
            return this._factory;
        }
    }

    protected static interface StoreFactory
    extends Serializable {
        public <K, V> Map<K, V> createMap();
    }

    protected static class InnerMap<L, R, E>
    extends AbstractEventMap<R, E> {
        private static final long serialVersionUID = -8381132398717092121L;
        protected final StoreFactory _factory;
        protected final L _left;
        protected final OuterMap<R, L, E> _otherMap;
        protected boolean _detached = false;
        private boolean _internalFlag = false;

        protected InnerMap(Map<R, E> decorated, StoreFactory factory, L left, OuterMap<R, L, E> otherMap) {
            super(decorated);
            this._factory = factory;
            this._left = left;
            this._otherMap = otherMap;
        }

        @Override
        public E put(R key, E value) {
            if (this._detached) {
                throw new IllegalStateException("Value set is detached! No further adding possible!");
            }
            return super.put(key, value);
        }

        protected void clearForReuse() {
            this._internalFlag = true;
            this.clear();
            this._internalFlag = false;
        }

        @Override
        protected void fireEntryAdded(R key, E value) {
            Map otherInternalMap = this._otherMap._internal;
            InnerMap<Object, Object, Object> otherInnerMap = otherInternalMap.get(key);
            if (otherInnerMap == null) {
                Map otherDecoratedMap = this._factory.createMap();
                otherInnerMap = new InnerMap(otherDecoratedMap, this._otherMap._factory, key, this._otherMap._partnerMap);
                otherInternalMap.put(key, otherInnerMap);
            }
            otherInnerMap.getDecorated().put(this._left, value);
        }

        @Override
        protected void fireEntryRemoved(R key, E value) {
            Map otherInternalMap = this._otherMap._internal;
            InnerMap otherInnerMap = otherInternalMap.get(key);
            otherInnerMap.getDecorated().remove(this._left);
            if (otherInnerMap.isEmpty()) {
                otherInnerMap._detached = true;
                otherInternalMap.remove(key);
            }
            if (this.isEmpty() && !this._internalFlag) {
                this._detached = true;
                this._otherMap._partnerMap._internal.remove(this._left);
            }
        }

        @Override
        protected void fireEntryUpdated(R key, E oldValue, E newValue) {
            Map otherInternalMap = this._otherMap._internal;
            InnerMap otherInnerMap = otherInternalMap.get(key);
            otherInnerMap.getDecorated().put(this._left, newValue);
        }
    }

    protected static class OuterMapEntry<L, R, E>
    implements Map.Entry<L, Map<R, E>> {
        private final OuterMap<L, R, E> _parentMap;
        private final Map.Entry<L, InnerMap<L, R, E>> _internalEntry;

        protected OuterMapEntry(OuterMap<L, R, E> parentMap, Map.Entry<L, InnerMap<L, R, E>> internalEntry) {
            this._parentMap = parentMap;
            this._internalEntry = internalEntry;
        }

        @Override
        public L getKey() {
            return this._internalEntry.getKey();
        }

        @Override
        public Map<R, E> getValue() {
            return this._internalEntry.getValue();
        }

        @Override
        public Map<R, E> setValue(Map<R, E> value) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("May not explicitly set null or an empty set as entry value!");
            }
            InnerMap<L, R, E> innerMap = this._internalEntry.getValue();
            Map result = this._parentMap._partnerMap._factory.createMap();
            result.putAll(innerMap.getDecorated());
            innerMap.clearForReuse();
            innerMap.putAll(value);
            return result;
        }

        public String toString() {
            return this.getKey() + "=[" + this.getValue() + "]";
        }
    }

    protected static class OuterMapEntrySetIterator<L, R, E>
    implements Iterator<Map.Entry<L, Map<R, E>>> {
        private final OuterMap<L, R, E> _parentMap;
        private final Iterator<Map.Entry<L, InnerMap<L, R, E>>> _internalIterator;
        private Map.Entry<L, InnerMap<L, R, E>> _last;

        protected OuterMapEntrySetIterator(OuterMap<L, R, E> parentMap, Iterator<Map.Entry<L, InnerMap<L, R, E>>> internalIterator) {
            this._parentMap = parentMap;
            this._internalIterator = internalIterator;
        }

        @Override
        public boolean hasNext() {
            return this._internalIterator.hasNext();
        }

        @Override
        public Map.Entry<L, Map<R, E>> next() {
            Map.Entry<L, InnerMap<L, R, E>> nextEntry = this._internalIterator.next();
            this._last = nextEntry;
            return new OuterMapEntry<L, R, E>(this._parentMap, nextEntry);
        }

        @Override
        public void remove() {
            this._internalIterator.remove();
            InnerMap<L, R, E> innerMap = this._last.getValue();
            innerMap.clear();
        }
    }

    protected static class OuterMapEntrySet<L, R, E>
    extends AbstractSet<Map.Entry<L, Map<R, E>>> {
        private final OuterMap<L, R, E> _parentMap;

        protected OuterMapEntrySet(OuterMap<L, R, E> parentMap) {
            this._parentMap = parentMap;
        }

        @Override
        public Iterator<Map.Entry<L, Map<R, E>>> iterator() {
            return new OuterMapEntrySetIterator<L, R, E>(this._parentMap, this._parentMap._internal.entrySet().iterator());
        }

        @Override
        public int size() {
            return this._parentMap._internal.size();
        }
    }

    protected static class OuterMap<L, R, E>
    extends AbstractMap<L, Map<R, E>>
    implements Map<L, Map<R, E>>,
    Serializable {
        private static final long serialVersionUID = 3088051603731444631L;
        protected final StoreFactory _factory;
        protected final Map<L, InnerMap<L, R, E>> _internal;
        protected final OuterMap<R, L, E> _partnerMap;

        protected OuterMap(StoreFactory factory, OuterMap<R, L, E> partnerMap) {
            this._factory = factory;
            this._internal = factory.createMap();
            this._partnerMap = partnerMap;
        }

        protected OuterMap(StoreFactory leftFactory, StoreFactory rightFactory) {
            this._factory = leftFactory;
            this._internal = leftFactory.createMap();
            this._partnerMap = new OuterMap<L, R, E>(rightFactory, this);
        }

        @Override
        public Set<Map.Entry<L, Map<R, E>>> entrySet() {
            return new OuterMapEntrySet(this);
        }

        @Override
        public Map<R, E> put(L key, Map<R, E> value) {
            Map result;
            if (key == null) {
                throw new IllegalArgumentException("Key mustn't be null!");
            }
            if (value == null || value.isEmpty()) {
                InnerMap<L, R, E> innerMap = this._internal.remove(key);
                if (innerMap == null) {
                    return null;
                }
                Map result2 = this._partnerMap._factory.createMap();
                result2.putAll(innerMap.getDecorated());
                innerMap.clear();
                return result2;
            }
            if (value.containsKey(null)) {
                throw new IllegalArgumentException("The value-set may not contain null!");
            }
            InnerMap<L, Object, Object> innerMap = this._internal.get(key);
            if (innerMap == null) {
                result = null;
                Map decorated = this._partnerMap._factory.createMap();
                innerMap = new InnerMap(decorated, this._factory, key, this._partnerMap);
                this._internal.put(key, innerMap);
            } else {
                result = this._partnerMap._factory.createMap();
                result.putAll(innerMap.getDecorated());
                innerMap.clearForReuse();
            }
            innerMap.putAll(value);
            return result;
        }

        @Override
        public Map<R, E> remove(Object key) {
            InnerMap<L, R, E> innerMap = this._internal.remove(key);
            if (innerMap == null) {
                return null;
            }
            Map result = this._partnerMap._factory.createMap();
            result.putAll(innerMap);
            innerMap.clear();
            return result;
        }

        @Override
        public Map<R, E> get(Object key) {
            return this._internal.get(key);
        }
    }
}

