/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.transformer;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils;
import net.sf.javagimmicks.collections.transformer.Transforming;

class KeyTransformingMap<KF, KT, V>
extends AbstractMap<KT, V>
implements Transforming<KF, KT> {
    protected final Map<KF, V> _internalMap;
    protected final Transformer<KF, KT> _transformer;

    @Deprecated
    public KeyTransformingMap(Map<KF, V> map, Transformer<KF, KT> transformer) {
        this._internalMap = map;
        this._transformer = transformer;
    }

    @Override
    public Transformer<KF, KT> getTransformer() {
        return this._transformer;
    }

    @Override
    public void clear() {
        this._internalMap.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this._internalMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<KT, V>> entrySet() {
        return TransformerUtils.decorate(this._internalMap.entrySet(), new KeyTransformingEntryTransformer(this.getTransformer()));
    }

    @Override
    public boolean isEmpty() {
        return this._internalMap.isEmpty();
    }

    @Override
    public Set<KT> keySet() {
        return TransformerUtils.decorate(this._internalMap.keySet(), this.getTransformer());
    }

    @Override
    public int size() {
        return this._internalMap.size();
    }

    @Override
    public Collection<V> values() {
        return this._internalMap.values();
    }

    protected KT transform(KF element) {
        return this.getTransformer().transform(element);
    }

    protected static class KeyTransformingEntryTransformer<KF, KT, V>
    implements Transformer<Map.Entry<KF, V>, Map.Entry<KT, V>> {
        protected final Transformer<KF, KT> _transformer;

        public KeyTransformingEntryTransformer(Transformer<KF, KT> transformer) {
            this._transformer = transformer;
        }

        @Override
        public Map.Entry<KT, V> transform(Map.Entry<KF, V> source) {
            return new KeyTransformingEntry<KF, KT, V>(source, this._transformer);
        }
    }

    protected static class KeyTransformingEntry<KF, KT, V>
    implements Map.Entry<KT, V>,
    Transforming<KF, KT> {
        protected final Map.Entry<KF, V> _internalEntry;
        protected final Transformer<KF, KT> _transformer;

        public KeyTransformingEntry(Map.Entry<KF, V> entry, Transformer<KF, KT> transformer) {
            this._internalEntry = entry;
            this._transformer = transformer;
        }

        @Override
        public Transformer<KF, KT> getTransformer() {
            return this._transformer;
        }

        @Override
        public KT getKey() {
            return this._transformer.transform(this._internalEntry.getKey());
        }

        @Override
        public V getValue() {
            return this._internalEntry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this._internalEntry.setValue(value);
        }
    }
}

