/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.transformer;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils;

public class NavigableKeySet<K, V>
extends AbstractSet<K>
implements NavigableSet<K> {
    protected final NavigableMap<K, V> _parent;

    public NavigableKeySet(NavigableMap<K, V> parent) {
        this._parent = parent;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this._parent.comparator();
    }

    @Override
    public K first() {
        return this._parent.firstKey();
    }

    @Override
    public K last() {
        return this._parent.lastKey();
    }

    @Override
    public Iterator<K> iterator() {
        Iterator entryIterator = this._parent.entrySet().iterator();
        return TransformerUtils.decorate(entryIterator, new KeyTransformer());
    }

    @Override
    public int size() {
        return this._parent.size();
    }

    @Override
    public K ceiling(K e) {
        return this._parent.ceilingKey(e);
    }

    @Override
    public Iterator<K> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public NavigableSet<K> descendingSet() {
        return this._parent.descendingKeySet();
    }

    @Override
    public K floor(K e) {
        return this._parent.floorKey(e);
    }

    @Override
    public K higher(K e) {
        return this._parent.higherKey(e);
    }

    @Override
    public K lower(K e) {
        return this._parent.lowerKey(e);
    }

    @Override
    public K pollFirst() {
        Map.Entry<K, V> firstEntry = this._parent.pollFirstEntry();
        return firstEntry != null ? (K)firstEntry.getKey() : null;
    }

    @Override
    public K pollLast() {
        Map.Entry<K, V> lastEntry = this._parent.pollLastEntry();
        return lastEntry != null ? (K)lastEntry.getKey() : null;
    }

    @Override
    public NavigableSet<K> headSet(K toElement, boolean inclusive) {
        return new NavigableKeySet<K, V>(this._parent.headMap(toElement, inclusive));
    }

    @Override
    public SortedSet<K> headSet(K toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
        return new NavigableKeySet<K, V>(this._parent.subMap(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public SortedSet<K> subSet(K fromElement, K toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
        return new NavigableKeySet<K, V>(this._parent.tailMap(fromElement, inclusive));
    }

    @Override
    public SortedSet<K> tailSet(K fromElement) {
        return this.tailSet(fromElement, true);
    }

    protected static class KeyTransformer<K, V>
    implements Transformer<Map.Entry<K, V>, K> {
        protected KeyTransformer() {
        }

        @Override
        public K transform(Map.Entry<K, V> source) {
            return source.getKey();
        }
    }
}

