/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.transformer;

import java.util.NavigableMap;
import java.util.NavigableSet;
import net.sf.javagimmicks.collections.transformer.BidiTransformer;
import net.sf.javagimmicks.collections.transformer.BidiTransformingNavigableSet;
import net.sf.javagimmicks.collections.transformer.KeyBidiTransformingNavigableMap;
import net.sf.javagimmicks.collections.transformer.KeyTransformingNavigableMap;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils15;
import net.sf.javagimmicks.collections.transformer.TransformingNavigableSet;
import net.sf.javagimmicks.collections.transformer.ValueBidiTransformingNavigableMap;
import net.sf.javagimmicks.collections.transformer.ValueTransformingNavigableMap;

public class TransformerUtils
extends TransformerUtils15 {
    protected TransformerUtils() {
    }

    public static <F, T> NavigableSet<T> decorate(NavigableSet<F> set, Transformer<F, T> transformer) {
        return new TransformingNavigableSet<F, T>(set, transformer);
    }

    public static <F, T> NavigableSet<T> decorate(NavigableSet<F> set, BidiTransformer<F, T> transformer) {
        return new BidiTransformingNavigableSet<F, T>(set, transformer);
    }

    public static <KF, KT, V> NavigableMap<KT, V> decorateKeyBased(NavigableMap<KF, V> map, Transformer<KF, KT> keyTransformer) {
        return new KeyTransformingNavigableMap<KF, KT, V>(map, keyTransformer);
    }

    public static <KF, KT, V> NavigableMap<KT, V> decorateKeyBased(NavigableMap<KF, V> map, BidiTransformer<KF, KT> keyTransformer) {
        return new KeyBidiTransformingNavigableMap<KF, KT, V>(map, keyTransformer);
    }

    public static <K, VF, VT> NavigableMap<K, VT> decorateValueBased(NavigableMap<K, VF> map, Transformer<VF, VT> valueTransformer) {
        return new ValueTransformingNavigableMap<K, VF, VT>(map, valueTransformer);
    }

    public static <K, VF, VT> NavigableMap<K, VT> decorateValueBased(NavigableMap<K, VF> map, BidiTransformer<VF, VT> valueTransformer) {
        return new ValueBidiTransformingNavigableMap<K, VF, VT>(map, valueTransformer);
    }

    public static <KF, KT, VF, VT> NavigableMap<KT, VT> decorate(NavigableMap<KF, VF> map, Transformer<KF, KT> keyTransformer, Transformer<VF, VT> valueTransformer) {
        NavigableMap<KF, VT> valueTransformingMap = TransformerUtils.decorateValueBased(map, valueTransformer);
        return TransformerUtils.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> NavigableMap<KT, VT> decorate(NavigableMap<KF, VF> map, BidiTransformer<KF, KT> keyTransformer, Transformer<VF, VT> valueTransformer) {
        NavigableMap<KF, VT> valueTransformingMap = TransformerUtils.decorateValueBased(map, valueTransformer);
        return TransformerUtils.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> NavigableMap<KT, VT> decorate(NavigableMap<KF, VF> map, Transformer<KF, KT> keyTransformer, BidiTransformer<VF, VT> valueTransformer) {
        NavigableMap<KF, VT> valueTransformingMap = TransformerUtils.decorateValueBased(map, valueTransformer);
        return TransformerUtils.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> NavigableMap<KT, VT> decorate(NavigableMap<KF, VF> map, BidiTransformer<KF, KT> keyTransformer, BidiTransformer<VF, VT> valueTransformer) {
        NavigableMap<KF, VT> valueTransformingMap = TransformerUtils.decorateValueBased(map, valueTransformer);
        return TransformerUtils.decorateKeyBased(valueTransformingMap, keyTransformer);
    }
}

