/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.transformer;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.sf.javagimmicks.collections.Ring;
import net.sf.javagimmicks.collections.Traverser;
import net.sf.javagimmicks.collections.transformer.BidiTransformer;
import net.sf.javagimmicks.collections.transformer.BidiTransforming;
import net.sf.javagimmicks.collections.transformer.BidiTransformingCollection;
import net.sf.javagimmicks.collections.transformer.BidiTransformingList;
import net.sf.javagimmicks.collections.transformer.BidiTransformingListIterator;
import net.sf.javagimmicks.collections.transformer.BidiTransformingRing;
import net.sf.javagimmicks.collections.transformer.BidiTransformingSet;
import net.sf.javagimmicks.collections.transformer.BidiTransformingSortedSet;
import net.sf.javagimmicks.collections.transformer.BidiTransformingTraverser;
import net.sf.javagimmicks.collections.transformer.KeyBidiTransformingMap;
import net.sf.javagimmicks.collections.transformer.KeyBidiTransformingSortedMap;
import net.sf.javagimmicks.collections.transformer.KeyTransformingMap;
import net.sf.javagimmicks.collections.transformer.KeyTransformingSortedMap;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.Transforming;
import net.sf.javagimmicks.collections.transformer.TransformingCollection;
import net.sf.javagimmicks.collections.transformer.TransformingComparator;
import net.sf.javagimmicks.collections.transformer.TransformingIterator;
import net.sf.javagimmicks.collections.transformer.TransformingList;
import net.sf.javagimmicks.collections.transformer.TransformingListIterator;
import net.sf.javagimmicks.collections.transformer.TransformingRing;
import net.sf.javagimmicks.collections.transformer.TransformingSet;
import net.sf.javagimmicks.collections.transformer.TransformingSortedSet;
import net.sf.javagimmicks.collections.transformer.TransformingTraverser;
import net.sf.javagimmicks.collections.transformer.ValueBidiTransformingMap;
import net.sf.javagimmicks.collections.transformer.ValueBidiTransformingSortedMap;
import net.sf.javagimmicks.collections.transformer.ValueTransformingMap;
import net.sf.javagimmicks.collections.transformer.ValueTransformingSortedMap;

public class TransformerUtils15 {
    protected TransformerUtils15() {
    }

    public static <E> Transformer<E, E> identityTransformer() {
        return TransformerUtils15.identityBidiTransformer();
    }

    public static <E> BidiTransformer<E, E> identityBidiTransformer() {
        return new BidiTransformer<E, E>(){

            @Override
            public E transform(E source) {
                return source;
            }

            @Override
            public BidiTransformer<E, E> invert() {
                return this;
            }

            @Override
            public E transformBack(E source) {
                return source;
            }
        };
    }

    public static <F, T> BidiTransformer<T, F> invert(final BidiTransformer<F, T> transformer) {
        return new BidiTransformer<T, F>(){

            @Override
            public T transformBack(F source) {
                return transformer.transform(source);
            }

            @Override
            public F transform(T source) {
                return transformer.transformBack(source);
            }

            @Override
            public BidiTransformer<F, T> invert() {
                return transformer;
            }
        };
    }

    public static boolean isTransforming(Object o) {
        return o instanceof Transforming;
    }

    public static boolean isBidiTransforming(Object o) {
        return o instanceof BidiTransforming;
    }

    public static Transformer<?, ?> getTransformer(Object transforming) {
        if (!TransformerUtils15.isTransforming(transforming)) {
            throw new IllegalArgumentException("Object is not transforming!");
        }
        return ((Transforming)transforming).getTransformer();
    }

    public static BidiTransformer<?, ?> getBidiTransformer(Object transforming) {
        if (!TransformerUtils15.isBidiTransforming(transforming)) {
            throw new IllegalArgumentException("Object is not bidi-transforming!");
        }
        return ((BidiTransforming)transforming).getBidiTransformer();
    }

    public static <F, T> Comparator<? super T> decorate(Comparator<? super F> comparator, Transformer<T, F> transformer) {
        return new TransformingComparator<F, T>(comparator, transformer);
    }

    public static <F, T> Iterator<T> decorate(Iterator<F> iterator, Transformer<F, T> transformer) {
        return new TransformingIterator<F, T>(iterator, transformer);
    }

    public static <F, T> ListIterator<T> decorate(ListIterator<F> iterator, Transformer<F, T> transformer) {
        return new TransformingListIterator<F, T>(iterator, transformer);
    }

    public static <F, T> ListIterator<T> decorate(ListIterator<F> iterator, BidiTransformer<F, T> transformer) {
        return new BidiTransformingListIterator<F, T>(iterator, transformer);
    }

    public static <F, T> Collection<T> decorate(Collection<F> collection, Transformer<F, T> transformer) {
        return new TransformingCollection<F, T>(collection, transformer);
    }

    public static <F, T> Collection<T> decorate(Collection<F> collection, BidiTransformer<F, T> transformer) {
        return new BidiTransformingCollection<F, T>(collection, transformer);
    }

    public static <F, T> Set<T> decorate(Set<F> set, Transformer<F, T> transformer) {
        return new TransformingSet<F, T>(set, transformer);
    }

    public static <F, T> Set<T> decorate(Set<F> set, BidiTransformer<F, T> transformer) {
        return new BidiTransformingSet<F, T>(set, transformer);
    }

    public static <F, T> SortedSet<T> decorate(SortedSet<F> set, Transformer<F, T> transformer) {
        return new TransformingSortedSet<F, T>(set, transformer);
    }

    public static <F, T> SortedSet<T> decorate(SortedSet<F> set, BidiTransformer<F, T> transformer) {
        return new BidiTransformingSortedSet<F, T>(set, transformer);
    }

    public static <F, T> List<T> decorate(List<F> list, Transformer<F, T> transformer) {
        return new TransformingList<F, T>(list, transformer);
    }

    public static <F, T> List<T> decorate(List<F> list, BidiTransformer<F, T> transformer) {
        return new BidiTransformingList<F, T>(list, transformer);
    }

    public static <KF, KT, V> Map<KT, V> decorateKeyBased(Map<KF, V> map, Transformer<KF, KT> keyTransformer) {
        return new KeyTransformingMap<KF, KT, V>(map, keyTransformer);
    }

    public static <KF, KT, V> Map<KT, V> decorateKeyBased(Map<KF, V> map, BidiTransformer<KF, KT> keyTransformer) {
        return new KeyBidiTransformingMap<KF, KT, V>(map, keyTransformer);
    }

    public static <KF, KT, V> SortedMap<KT, V> decorateKeyBased(SortedMap<KF, V> map, Transformer<KF, KT> keyTransformer) {
        return new KeyTransformingSortedMap<KF, KT, V>(map, keyTransformer);
    }

    public static <KF, KT, V> SortedMap<KT, V> decorateKeyBased(SortedMap<KF, V> map, BidiTransformer<KF, KT> keyTransformer) {
        return new KeyBidiTransformingSortedMap<KF, KT, V>(map, keyTransformer);
    }

    public static <K, VF, VT> Map<K, VT> decorateValueBased(Map<K, VF> map, Transformer<VF, VT> valueTransformer) {
        return new ValueTransformingMap<K, VF, VT>(map, valueTransformer);
    }

    public static <K, VF, VT> Map<K, VT> decorateValueBased(Map<K, VF> map, BidiTransformer<VF, VT> valueTransformer) {
        return new ValueBidiTransformingMap<K, VF, VT>(map, valueTransformer);
    }

    public static <K, VF, VT> SortedMap<K, VT> decorateValueBased(SortedMap<K, VF> map, Transformer<VF, VT> valueTransformer) {
        return new ValueTransformingSortedMap<K, VF, VT>(map, valueTransformer);
    }

    public static <K, VF, VT> SortedMap<K, VT> decorateValueBased(SortedMap<K, VF> map, BidiTransformer<VF, VT> valueTransformer) {
        return new ValueBidiTransformingSortedMap<K, VF, VT>(map, valueTransformer);
    }

    public static <KF, KT, VF, VT> Map<KT, VT> decorate(Map<KF, VF> map, Transformer<KF, KT> keyTransformer, Transformer<VF, VT> valueTransformer) {
        Map<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> Map<KT, VT> decorate(Map<KF, VF> map, BidiTransformer<KF, KT> keyTransformer, Transformer<VF, VT> valueTransformer) {
        Map<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> Map<KT, VT> decorate(Map<KF, VF> map, Transformer<KF, KT> keyTransformer, BidiTransformer<VF, VT> valueTransformer) {
        Map<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> Map<KT, VT> decorate(Map<KF, VF> map, BidiTransformer<KF, KT> keyTransformer, BidiTransformer<VF, VT> valueTransformer) {
        Map<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> SortedMap<KT, VT> decorate(SortedMap<KF, VF> map, Transformer<KF, KT> keyTransformer, Transformer<VF, VT> valueTransformer) {
        SortedMap<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> SortedMap<KT, VT> decorate(SortedMap<KF, VF> map, BidiTransformer<KF, KT> keyTransformer, Transformer<VF, VT> valueTransformer) {
        SortedMap<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> SortedMap<KT, VT> decorate(SortedMap<KF, VF> map, Transformer<KF, KT> keyTransformer, BidiTransformer<VF, VT> valueTransformer) {
        SortedMap<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <KF, KT, VF, VT> SortedMap<KT, VT> decorate(SortedMap<KF, VF> map, BidiTransformer<KF, KT> keyTransformer, BidiTransformer<VF, VT> valueTransformer) {
        SortedMap<KF, VT> valueTransformingMap = TransformerUtils15.decorateValueBased(map, valueTransformer);
        return TransformerUtils15.decorateKeyBased(valueTransformingMap, keyTransformer);
    }

    public static <F, T> Traverser<T> decorate(Traverser<F> traverser, Transformer<F, T> transformer) {
        return new TransformingTraverser<F, T>(traverser, transformer);
    }

    public static <F, T> Traverser<T> decorate(Traverser<F> traverser, BidiTransformer<F, T> transformer) {
        return new BidiTransformingTraverser<F, T>(traverser, transformer);
    }

    public static <F, T> Ring<T> decorate(Ring<F> ring, Transformer<F, T> transformer) {
        return new TransformingRing<F, T>(ring, transformer);
    }

    public static <F, T> Ring<T> decorate(Ring<F> ring, BidiTransformer<F, T> transformer) {
        return new BidiTransformingRing<F, T>(ring, transformer);
    }
}

