/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.transformer;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils;
import net.sf.javagimmicks.collections.transformer.Transforming;

class ValueTransformingMap<K, VF, VT>
extends AbstractMap<K, VT>
implements Transforming<VF, VT> {
    protected final Map<K, VF> _internalMap;
    private final Transformer<VF, VT> _transformer;

    @Deprecated
    public ValueTransformingMap(Map<K, VF> map, Transformer<VF, VT> valueTransformer) {
        this._internalMap = map;
        this._transformer = valueTransformer;
    }

    @Override
    public Transformer<VF, VT> getTransformer() {
        return this._transformer;
    }

    @Override
    public void clear() {
        this._internalMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._internalMap.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, VT>> entrySet() {
        return TransformerUtils.decorate(this._internalMap.entrySet(), new ValueTransformingEntryTransformer(this.getTransformer()));
    }

    @Override
    public VT get(Object key) {
        VF result = this._internalMap.get(key);
        if (result == null && !this.containsKey(key)) {
            return null;
        }
        return this.transform(result);
    }

    @Override
    public boolean isEmpty() {
        return this._internalMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this._internalMap.keySet();
    }

    @Override
    public VT remove(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        VF result = this._internalMap.remove(key);
        return this.transform(result);
    }

    @Override
    public int size() {
        return this._internalMap.size();
    }

    @Override
    public Collection<VT> values() {
        return TransformerUtils.decorate(this._internalMap.values(), this.getTransformer());
    }

    protected VT transform(VF element) {
        return this.getTransformer().transform(element);
    }

    protected static class ValueTransformingEntryTransformer<K, VF, VT>
    implements Transformer<Map.Entry<K, VF>, Map.Entry<K, VT>> {
        protected final Transformer<VF, VT> _transformer;

        public ValueTransformingEntryTransformer(Transformer<VF, VT> transformer) {
            this._transformer = transformer;
        }

        @Override
        public Map.Entry<K, VT> transform(Map.Entry<K, VF> source) {
            return new ValueTransformingEntry<K, VF, VT>(source, this._transformer);
        }
    }

    protected static class ValueTransformingEntry<K, VF, VT>
    implements Map.Entry<K, VT>,
    Transforming<VF, VT> {
        protected final Transformer<VF, VT> _transformer;
        protected final Map.Entry<K, VF> _internalEntry;

        public ValueTransformingEntry(Map.Entry<K, VF> entry, Transformer<VF, VT> transformer) {
            this._transformer = transformer;
            this._internalEntry = entry;
        }

        @Override
        public Transformer<VF, VT> getTransformer() {
            return this._transformer;
        }

        @Override
        public K getKey() {
            return this._internalEntry.getKey();
        }

        @Override
        public VT getValue() {
            return this.getTransformer().transform(this._internalEntry.getValue());
        }

        @Override
        public VT setValue(VT value) {
            throw new UnsupportedOperationException();
        }
    }
}

