/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.concurrent.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.javagimmicks.concurrent.MultiLock;
import net.sf.javagimmicks.concurrent.MultiLockProvider;
import net.sf.javagimmicks.concurrent.MultiReadWriteLock;
import net.sf.javagimmicks.concurrent.impl.LockRegistry;
import net.sf.javagimmicks.concurrent.impl.RegistryLockProvider;

public class RegistryLockProvider<K>
implements MultiLockProvider<K>,
Serializable {
    private static final long serialVersionUID = 6807627151240655773L;
    protected final LockRegistry<K> _registry;
    protected final Lock _exLock = new ReentrantLock();
    protected final Condition _exCondition = this._exLock.newCondition();
    protected final Lock _shLock = new ReentrantLock();
    protected final Condition _shCondition = this._shLock.newCondition();

    public RegistryLockProvider(LockRegistry<K> registry) {
        this._registry = registry;
    }

    @Override
    public final MultiReadWriteLock<K> newLock(Collection<K> resources) {
        return new MultiReadWriteLockImpl(resources);
    }

    protected class MultiReadWriteLockImpl
    implements MultiReadWriteLock<K> {
        protected final Collection<K> _resources;
        protected final net.sf.javagimmicks.concurrent.impl.RegistryLockProvider$MultiReadWriteLockImpl.MultiReadLockImpl _readLock;
        protected final net.sf.javagimmicks.concurrent.impl.RegistryLockProvider$MultiReadWriteLockImpl.MultiWriteLockImpl _writeLock;

        protected MultiReadWriteLockImpl(Collection<K> resources) {
            ArrayList internalResourceList = new ArrayList();
            for (Object resource : resources) {
                if (resource == null) continue;
                internalResourceList.add(resource);
            }
            this._resources = Collections.unmodifiableCollection(internalResourceList);
            this._readLock = new MultiReadLockImpl();
            this._writeLock = new MultiWriteLockImpl();
        }

        @Override
        public Collection<K> getResources() {
            return this._resources;
        }

        @Override
        public MultiLock<K> readLock() {
            return this._readLock;
        }

        @Override
        public MultiLock<K> writeLock() {
            return this._writeLock;
        }

        protected class MultiWriteLockImpl
        extends MultiLockImpl {
            protected MultiWriteLockImpl() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void lockInternal() {
                RegistryLockProvider.this._exLock.lock();
                try {
                    while (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        RegistryLockProvider.this._exCondition.awaitUninterruptibly();
                    }
                    RegistryLockProvider.this._registry.registerExclusive(this.getResources());
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
                RegistryLockProvider.this._shLock.lock();
                try {
                    while (!RegistryLockProvider.this._registry.isSharedFree(this.getResources())) {
                        RegistryLockProvider.this._shCondition.awaitUninterruptibly();
                    }
                    RegistryLockProvider.this._shLock.unlock();
                }
                catch (Error e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
                catch (RuntimeException e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void lockInterruptiblyInternal() throws InterruptedException {
                RegistryLockProvider.this._exLock.lockInterruptibly();
                try {
                    while (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        RegistryLockProvider.this._exCondition.await();
                    }
                    RegistryLockProvider.this._registry.registerExclusive(this.getResources());
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
                try {
                    RegistryLockProvider.this._shLock.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    this.unlockInternal();
                    throw e;
                }
                try {
                    while (!RegistryLockProvider.this._registry.isSharedFree(this.getResources())) {
                        RegistryLockProvider.this._shCondition.await();
                    }
                    RegistryLockProvider.this._shLock.unlock();
                }
                catch (Error e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
                catch (RuntimeException e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
                catch (InterruptedException e) {
                    try {
                        RegistryLockProvider.this._shLock.unlock();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        // empty catch block
                    }
                    this.unlockInternal();
                    throw e;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean tryLockInternal() {
                if (!RegistryLockProvider.this._exLock.tryLock()) {
                    return false;
                }
                try {
                    if (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        boolean bl = false;
                        return bl;
                    }
                    RegistryLockProvider.this._registry.registerExclusive(this.getResources());
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
                if (!RegistryLockProvider.this._shLock.tryLock()) {
                    this.unlockInternal();
                    return false;
                }
                try {
                    if (!RegistryLockProvider.this._registry.isSharedFree(this.getResources())) {
                        RegistryLockProvider.this._shLock.unlock();
                        this.unlockInternal();
                        return false;
                    }
                    RegistryLockProvider.this._shLock.unlock();
                }
                catch (Error e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
                catch (RuntimeException e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean tryLockInternal(long time, TimeUnit unit) throws InterruptedException {
                long nanoTimestamp = System.nanoTime();
                if (!RegistryLockProvider.this._exLock.tryLock(time, unit)) {
                    return false;
                }
                long nanosLeft = unit.toNanos(time) - (System.nanoTime() - nanoTimestamp);
                if (nanosLeft <= 0L) {
                    RegistryLockProvider.this._exLock.unlock();
                    return false;
                }
                try {
                    while (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        if ((nanosLeft = RegistryLockProvider.this._exCondition.awaitNanos(nanosLeft)) > 0L) continue;
                        boolean bl = false;
                        return bl;
                    }
                    RegistryLockProvider.this._registry.registerExclusive(this.getResources());
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
                nanoTimestamp = System.nanoTime();
                try {
                    if (nanosLeft <= 0L || !RegistryLockProvider.this._shLock.tryLock(nanosLeft, TimeUnit.NANOSECONDS)) {
                        this.unlockInternal();
                        return false;
                    }
                }
                catch (InterruptedException e) {
                    this.unlockInternal();
                    throw e;
                }
                if ((nanosLeft -= System.nanoTime() - nanoTimestamp) <= 0L) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    return false;
                }
                try {
                    while (!RegistryLockProvider.this._registry.isSharedFree(this.getResources())) {
                        if ((nanosLeft = RegistryLockProvider.this._shCondition.awaitNanos(nanosLeft)) > 0L) continue;
                        RegistryLockProvider.this._shLock.unlock();
                        this.unlockInternal();
                        return false;
                    }
                    RegistryLockProvider.this._shLock.unlock();
                }
                catch (Error e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
                catch (RuntimeException e) {
                    RegistryLockProvider.this._shLock.unlock();
                    this.unlockInternal();
                    throw e;
                }
                catch (InterruptedException e) {
                    try {
                        RegistryLockProvider.this._shLock.unlock();
                    }
                    catch (IllegalMonitorStateException ex) {
                        // empty catch block
                    }
                    this.unlockInternal();
                    throw e;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void unlockInternal() {
                Thread currentThread = Thread.currentThread();
                int priority = currentThread.getPriority();
                try {
                    currentThread.setPriority(10);
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
                RegistryLockProvider.this._exLock.lock();
                try {
                    RegistryLockProvider.this._registry.unregisterExclusive(this.getResources());
                    RegistryLockProvider.this._exCondition.signalAll();
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                    try {
                        currentThread.setPriority(priority);
                    }
                    catch (SecurityException securityException) {}
                }
            }
        }

        protected class MultiReadLockImpl
        extends MultiLockImpl {
            protected MultiReadLockImpl() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void lockInternal() {
                RegistryLockProvider.this._exLock.lock();
                try {
                    while (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        RegistryLockProvider.this._exCondition.awaitUninterruptibly();
                    }
                    RegistryLockProvider.this._shLock.lock();
                    try {
                        RegistryLockProvider.this._registry.registerShared(this.getResources());
                    }
                    finally {
                        RegistryLockProvider.this._shLock.unlock();
                    }
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void lockInterruptiblyInternal() throws InterruptedException {
                RegistryLockProvider.this._exLock.lockInterruptibly();
                try {
                    while (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        RegistryLockProvider.this._exCondition.await();
                    }
                    RegistryLockProvider.this._shLock.lockInterruptibly();
                    try {
                        RegistryLockProvider.this._registry.registerShared(this.getResources());
                    }
                    finally {
                        RegistryLockProvider.this._shLock.unlock();
                    }
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean tryLockInternal() {
                if (!RegistryLockProvider.this._exLock.tryLock()) {
                    return false;
                }
                try {
                    if (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!RegistryLockProvider.this._shLock.tryLock()) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        RegistryLockProvider.this._registry.registerShared(this.getResources());
                    }
                    finally {
                        RegistryLockProvider.this._shLock.unlock();
                    }
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean tryLockInternal(long time, TimeUnit unit) throws InterruptedException {
                long nanosTimestamp = System.nanoTime();
                if (!RegistryLockProvider.this._exLock.tryLock(time, unit)) {
                    return false;
                }
                long nanosLeft = unit.toNanos(time) - (System.nanoTime() - nanosTimestamp);
                try {
                    while (!RegistryLockProvider.this._registry.isExclusiveFree(this.getResources())) {
                        if ((nanosLeft = RegistryLockProvider.this._exCondition.awaitNanos(nanosLeft)) > 0L) continue;
                        boolean bl = false;
                        return bl;
                    }
                    if (!RegistryLockProvider.this._shLock.tryLock(nanosLeft, TimeUnit.NANOSECONDS)) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        RegistryLockProvider.this._registry.registerShared(this.getResources());
                    }
                    finally {
                        RegistryLockProvider.this._shLock.unlock();
                    }
                }
                finally {
                    RegistryLockProvider.this._exLock.unlock();
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void unlockInternal() {
                Thread currentThread = Thread.currentThread();
                int priority = currentThread.getPriority();
                try {
                    currentThread.setPriority(10);
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
                RegistryLockProvider.this._shLock.lock();
                try {
                    RegistryLockProvider.this._registry.unregisterShared(this.getResources());
                    RegistryLockProvider.this._shCondition.signalAll();
                }
                finally {
                    RegistryLockProvider.this._shLock.unlock();
                    try {
                        currentThread.setPriority(priority);
                    }
                    catch (SecurityException securityException) {}
                }
            }
        }

        protected abstract class MultiLockImpl
        implements MultiLock<K> {
            protected final ThreadLocal<Boolean> _lockedFlag = new ThreadLocal();

            protected MultiLockImpl() {
            }

            @Override
            public final Collection<K> getResources() {
                return MultiReadWriteLockImpl.this.getResources();
            }

            @Override
            public boolean isLockedByThisThread() {
                Boolean b = this._lockedFlag.get();
                return b != null && b != false;
            }

            @Override
            public void lock() {
                this.testUnlocked();
                this.lockInternal();
                this.setLockedByThisThread(true);
            }

            @Override
            public void lockInterruptibly() throws InterruptedException {
                this.testUnlocked();
                this.lockInterruptiblyInternal();
                this.setLockedByThisThread(true);
            }

            @Override
            public Condition newCondition() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean tryLock() {
                this.testUnlocked();
                boolean result = this.tryLockInternal();
                if (result) {
                    this.setLockedByThisThread(true);
                }
                return result;
            }

            @Override
            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                this.testUnlocked();
                boolean result = this.tryLockInternal(time, unit);
                if (result) {
                    this.setLockedByThisThread(true);
                }
                return result;
            }

            @Override
            public void unlock() {
                this.testLocked();
                this.unlockInternal();
                this.setLockedByThisThread(false);
            }

            protected final void setLockedByThisThread(boolean locked) {
                this._lockedFlag.set(locked ? Boolean.TRUE : null);
            }

            protected void testLocked() {
                if (!this.isLockedByThisThread()) {
                    throw new IllegalStateException("Lock is not locked by this thread!");
                }
            }

            protected void testUnlocked() {
                if (this.isLockedByThisThread()) {
                    throw new IllegalStateException("Lock is already locked by this thread!");
                }
            }

            protected abstract void lockInternal();

            protected abstract void lockInterruptiblyInternal() throws InterruptedException;

            protected abstract boolean tryLockInternal();

            protected abstract boolean tryLockInternal(long var1, TimeUnit var3) throws InterruptedException;

            protected abstract void unlockInternal();
        }
    }
}

