/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.collections.AbstractMap2;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils15;
import net.sf.javagimmicks.graph.Edge;
import net.sf.javagimmicks.graph.Graph;
import net.sf.javagimmicks.lang.Factory;
import net.sf.javagimmicks.lang.LangUtils;

public abstract class AbstractGraph<V, E extends Edge<V, E>>
implements Graph<V, E> {
    protected final Factory<? extends Set<E>> _edgeSetFactory;

    protected AbstractGraph(Factory<? extends Set<E>> edgeSetFactory) {
        this._edgeSetFactory = edgeSetFactory;
    }

    @Override
    public Map<V, Set<E>> edgeMap() {
        return new EdgeMap();
    }

    @Override
    public boolean addVertex(V vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E addEdge(V source, V target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<E> addEdges(V source, Collection<? extends V> targets) {
        Set<E> result = this.createEdgeSet();
        for (V target : targets) {
            E edge = this.addEdge(source, target);
            result.add(edge);
        }
        return result;
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.vertexSet().contains(vertex);
    }

    @Override
    public Set<V> targetsOf(V source) {
        return TransformerUtils15.decorate(this.edgesOf(source), new EdgeToTargetTransformer(source));
    }

    @Override
    public Set<E> getEdges(V source, V target) {
        Set<Edge> result = this.createEdgeSet();
        for (Edge edge : this.edgesOf(source)) {
            V currentTarget = edge.getOutgoingVertex(source);
            if (!LangUtils.equalsNullSafe(target, currentTarget)) continue;
            result.add(edge);
        }
        return result;
    }

    @Override
    public E getEdge(V source, V target) {
        for (Edge edge : this.edgesOf(source)) {
            V currentTarget = edge.getOutgoingVertex(source);
            if (!LangUtils.equalsNullSafe(target, currentTarget)) continue;
            return (E)edge;
        }
        return null;
    }

    @Override
    public boolean isConnected(V source, V target) {
        return this.getEdge(source, target) != null;
    }

    @Override
    public Set<E> removeEdges(V source, V target) {
        Set<Edge> result = this.createEdgeSet();
        Iterator edges = this.edgesOf(source).iterator();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            V currentTarget = edge.getOutgoingVertex(source);
            if (!LangUtils.equalsNullSafe(target, currentTarget)) continue;
            edges.remove();
            result.add(edge);
        }
        return result;
    }

    @Override
    public E removeEdge(V source, V target) {
        Iterator edges = this.edgesOf(source).iterator();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            V currentTarget = edge.getOutgoingVertex(source);
            if (target == null) {
                if (currentTarget != null) continue;
                edges.remove();
                return (E)edge;
            }
            if (!target.equals(currentTarget)) continue;
            edges.remove();
            return (E)edge;
        }
        return null;
    }

    @Override
    public Set<E> removeEdges(V source, Collection<? extends V> targets) {
        Set<Edge> result = this.createEdgeSet();
        Iterator edges = this.edgesOf(source).iterator();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            if (!targets.contains(edge.getOutgoingVertex(source))) continue;
            edges.remove();
            result.add(edge);
        }
        return result;
    }

    @Override
    public Set<E> removeVertex(V vertex) {
        return this.edgeMap().remove(vertex);
    }

    protected Set<E> createEdgeSet() {
        return this._edgeSetFactory.create();
    }

    protected static class EdgeToTargetTransformer<E extends Edge<V, E>, V>
    implements Transformer<E, V> {
        protected final V _source;

        public EdgeToTargetTransformer(V source) {
            this._source = source;
        }

        @Override
        public V transform(E edge) {
            return edge.getOutgoingVertex(this._source);
        }
    }

    protected class EdgeMap
    extends AbstractMap2<V, Set<E>> {
        protected EdgeMap() {
        }

        @Override
        public Set<V> keySet() {
            return AbstractGraph.this.vertexSet();
        }

        @Override
        protected Set<E> getValue(V key) {
            return AbstractGraph.this.edgesOf(key);
        }
    }
}

