/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.graph;

import java.util.Arrays;
import java.util.Collection;
import net.sf.javagimmicks.graph.DirectedEdge;
import net.sf.javagimmicks.graph.Edge;
import net.sf.javagimmicks.graph.EdgeFactory;
import net.sf.javagimmicks.graph.Graph;
import net.sf.javagimmicks.graph.WeightedEdge;
import net.sf.javagimmicks.lang.LangUtils;

public class DefaultEdgeFactory<V>
implements EdgeFactory<V, DefaultEdge<V>> {
    @Override
    public DefaultEdge<V> createEdge(Graph<V, DefaultEdge<V>> graph, V source, V target) {
        return new DefaultEdge<V>(graph, source, target);
    }

    public static class DefaultEdge<V>
    extends AbstractDefaultEdge<V, DefaultEdge<V>> {
        public DefaultEdge(Graph<V, DefaultEdge<V>> graph, V source, V target) {
            super(graph, source, target);
        }
    }

    public static abstract class AbstractDefaultEdge<V, E extends AbstractDefaultEdge<V, E>>
    implements Edge<V, E>,
    DirectedEdge<V, E>,
    WeightedEdge<V, E> {
        protected final Graph<V, ? extends E> _graph;
        protected final V _source;
        protected final V _target;
        protected double _cost = 1.0;

        public AbstractDefaultEdge(Graph<V, ? extends E> graph, V source, V target) {
            this._graph = graph;
            this._source = source;
            this._target = target;
        }

        @Override
        public double getCost() {
            return this._cost;
        }

        @Override
        public void setCost(double cost) {
            this._cost = cost;
        }

        @Override
        public Graph<V, ? extends E> getGraph() {
            return this._graph;
        }

        @Override
        public V getSourceVertex() {
            return this._source;
        }

        @Override
        public V getTargetVertex() {
            return this._target;
        }

        @Override
        public V getOutgoingVertex(V incoming) {
            if (LangUtils.equalsNullSafe(incoming, this._source)) {
                return this._target;
            }
            if (LangUtils.equalsNullSafe(incoming, this._target)) {
                return this._source;
            }
            return null;
        }

        @Override
        public boolean connectsTo(V vertex) {
            return LangUtils.equalsNullSafe(vertex, this._source) || LangUtils.equalsNullSafe(vertex, this._target);
        }

        @Override
        public Collection<V> getVerteces() {
            return Arrays.asList(this._source, this._target);
        }

        @Override
        public String toString(V incoming) {
            return incoming + "->" + this.getOutgoingVertex(incoming);
        }

        public String toString() {
            return this.toString(this._source);
        }
    }
}

