/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.graph;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.javagimmicks.graph.Edge;
import net.sf.javagimmicks.graph.Route;
import net.sf.javagimmicks.graph.WeightedEdge;

public class DefaultRoute<V, E extends Edge<V, E>>
extends ArrayList<E>
implements Route<V, E> {
    private static final long serialVersionUID = 8309167375893037566L;
    protected final V _source;
    protected final V _target;

    public DefaultRoute(V source, V target) {
        this._source = source;
        this._target = target;
    }

    @Override
    public double getCost() {
        double cost = 0.0;
        for (Edge edge : this) {
            cost += edge instanceof WeightedEdge ? ((WeightedEdge)edge).getCost() : 1.0;
        }
        return cost;
    }

    @Override
    public V getSourceVertex() {
        return this._source;
    }

    @Override
    public V getTargetVertex() {
        return this._target;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder().append(this._source).append("->").append(this._target);
        if (!this.isEmpty()) {
            result.append(" (");
            Iterator edgeIterator = this.iterator();
            V source = this._source;
            Edge edge = (Edge)edgeIterator.next();
            result.append(edge.toString(this._source));
            while (edgeIterator.hasNext()) {
                source = edge.getOutgoingVertex(source);
                edge = (Edge)edgeIterator.next();
                result.append(", ").append(edge.toString(source));
            }
            result.append(")");
        }
        return result.append(" / Overall cost: ").append(this.getCost()).toString();
    }
}

