/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.graph;

import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.graph.AbstractGraph;
import net.sf.javagimmicks.graph.Edge;
import net.sf.javagimmicks.graph.EdgeFactory;
import net.sf.javagimmicks.lang.Factory;

public class MapGraph<V, E extends Edge<V, E>>
extends AbstractGraph<V, E> {
    protected final Map<V, Set<E>> _edges;
    protected final EdgeFactory<V, E> _edgeFactory;
    protected final boolean _directed;

    MapGraph(Map<V, Set<E>> edges, Factory<? extends Set<E>> setFactory, EdgeFactory<V, E> edgeFactory, boolean directed) {
        super(setFactory);
        this._edges = edges;
        this._edgeFactory = edgeFactory;
        this._directed = directed;
    }

    @Override
    public Set<E> edgesOf(V source) {
        return this._edges.get(source);
    }

    @Override
    public Set<V> vertexSet() {
        return this._edges.keySet();
    }

    @Override
    public E addEdge(V source, V target) {
        this.addVertex(source);
        this.addVertex(target);
        E edge = this._edgeFactory.createEdge(this, source, target);
        this._edges.get(source).add(edge);
        if (!this._directed) {
            this._edges.get(target).add(edge);
        }
        return edge;
    }

    @Override
    public boolean addVertex(V vertex) {
        if (this._edges.containsKey(vertex)) {
            return false;
        }
        this._edges.put(vertex, this.createEdgeSet());
        return true;
    }
}

