/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.javagimmicks.graph.DefaultEdgeFactory;
import net.sf.javagimmicks.graph.Edge;
import net.sf.javagimmicks.graph.EdgeFactory;
import net.sf.javagimmicks.graph.MapGraph;
import net.sf.javagimmicks.lang.Factory;

public class MapGraphBuilder<V, E extends Edge<V, E>> {
    protected boolean _directed = false;
    protected Map<V, Set<E>> _edgeMap = new HashMap<V, Set<E>>();
    protected Factory<? extends Set<E>> _setFactory = new HashSetFactory();
    protected EdgeFactory<V, E> _edgeFactory = null;

    public static <V> MapGraphBuilder<V, DefaultEdgeFactory.DefaultEdge<V>> createDefaultInstance(Map<V, Set<DefaultEdgeFactory.DefaultEdge<V>>> edges, Factory<Set<DefaultEdgeFactory.DefaultEdge<V>>> setFactory) {
        return new MapGraphBuilder<V, DefaultEdgeFactory.DefaultEdge<V>>().setEdgeMap(edges).setSetFactory(setFactory).setEdgeFactory(new DefaultEdgeFactory());
    }

    public static <V> MapGraphBuilder<V, DefaultEdgeFactory.DefaultEdge<V>> createDefaultHashInstance() {
        return MapGraphBuilder.createDefaultInstance(new HashMap(), new HashSetFactory<DefaultEdgeFactory.DefaultEdge<V>>());
    }

    public MapGraph<V, E> build() {
        if (this._edgeFactory == null) {
            throw new IllegalStateException("No EdgeFactory set yet!");
        }
        return new MapGraph<V, E>(this._edgeMap, this._setFactory, this._edgeFactory, this._directed);
    }

    public boolean isDirected() {
        return this._directed;
    }

    public Map<V, Set<E>> getEdgeMap() {
        return this._edgeMap;
    }

    public Factory<? extends Set<E>> getSetFactory() {
        return this._setFactory;
    }

    public EdgeFactory<V, E> getEdgeFactory() {
        return this._edgeFactory;
    }

    public MapGraphBuilder<V, E> setDirected(boolean directed) {
        this._directed = directed;
        return this;
    }

    public MapGraphBuilder<V, E> setEdgeMap(Map<V, Set<E>> edgeMap) {
        this._edgeMap = edgeMap;
        return this;
    }

    public MapGraphBuilder<V, E> setSetFactory(Factory<? extends Set<E>> setFactory) {
        this._setFactory = setFactory;
        return this;
    }

    public MapGraphBuilder<V, E> setEdgeFactory(EdgeFactory<V, E> edgeFactory) {
        this._edgeFactory = edgeFactory;
        return this;
    }

    public static class TreeSetFactory<E>
    implements Factory<Set<E>> {
        @Override
        public Set<E> create() {
            return new TreeSet();
        }
    }

    public static class HashSetFactory<E>
    implements Factory<Set<E>> {
        @Override
        public Set<E> create() {
            return new HashSet();
        }
    }
}

