/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.graph.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.javagimmicks.graph.AbstractRouteFinder;
import net.sf.javagimmicks.graph.DefaultRoute;
import net.sf.javagimmicks.graph.Edge;
import net.sf.javagimmicks.graph.Graph;
import net.sf.javagimmicks.graph.Route;
import net.sf.javagimmicks.graph.WeightedEdge;

public class DijkstraRouteFinder<V, E extends Edge<V, E>>
extends AbstractRouteFinder<V, E> {
    public static <V, E extends Edge<V, E>> DijkstraRouteFinder<V, E> createInstance(Graph<V, E> graph) {
        return new DijkstraRouteFinder<V, E>(graph);
    }

    public DijkstraRouteFinder(Graph<V, E> graph) {
        super(graph);
    }

    @Override
    public Route<V, E> findRoute(V source, V target) {
        HashMap result = new HashMap();
        DijkstraRouteFinder.findRoutes(this._graph, source, result, target);
        return (Route)result.get(target);
    }

    @Override
    public Map<V, Route<V, E>> findRoutes(V source) {
        HashMap result = new HashMap();
        DijkstraRouteFinder.findRoutes(this._graph, source, result, null);
        return result;
    }

    public static <V, E extends Edge<V, E>> void findRoutes(Graph<V, E> graph, V source, Map<V, Route<V, E>> routes, V optionalTargetVertex) {
        HashMap<V, Double> costs = new HashMap<V, Double>();
        costs.put(source, 0.0);
        HashMap previous = new HashMap();
        DijkstraRouteFinder.doFindRoutes(graph, costs, previous, optionalTargetVertex);
        if (optionalTargetVertex == null) {
            for (Object target : previous.keySet()) {
                DijkstraRouteFinder.createAddRoute(routes, costs, previous, target);
            }
        } else {
            DijkstraRouteFinder.createAddRoute(routes, costs, previous, optionalTargetVertex);
        }
    }

    protected static <V, E extends Edge<V, E>> void doFindRoutes(Graph<V, E> graph, Map<V, Double> costs, Map<V, E> previous, V optionalTargetVertex) {
        Object currentVertex;
        Double currentCost;
        ArrayList<V> vertexList = new ArrayList<V>(graph.vertexSet());
        DijkstraRouteFinder.sortVertecesByCost(vertexList, costs);
        while (!vertexList.isEmpty() && (currentCost = costs.get(currentVertex = vertexList.remove(0))) != null) {
            for (Edge edge : graph.edgesOf(currentVertex)) {
                Object targetVertex = edge.getOutgoingVertex(currentVertex);
                double targetNewCost = currentCost + (edge instanceof WeightedEdge ? ((WeightedEdge)edge).getCost() : 1.0);
                Double targetCurrentCost = costs.get(targetVertex);
                if (targetCurrentCost == null || targetNewCost < targetCurrentCost) {
                    costs.put((Double)targetVertex, targetNewCost);
                    previous.put((Edge)targetVertex, (E)edge);
                    DijkstraRouteFinder.sortVertecesByCost(vertexList, costs);
                }
                if (optionalTargetVertex == null || !optionalTargetVertex.equals(targetVertex)) continue;
                return;
            }
        }
    }

    protected static <V, E extends Edge<V, E>> void createAddRoute(Map<V, Route<V, E>> routes, Map<V, Double> costs, Map<V, E> previous, V target) {
        if (routes.containsKey(target)) {
            return;
        }
        Edge edge = (Edge)previous.get(target);
        if (edge == null) {
            routes.put(target, new DefaultRoute(target, target));
            return;
        }
        V source = edge.getOutgoingVertex(target);
        DijkstraRouteFinder.createAddRoute(routes, costs, previous, source);
        Route<V, E> sourceRoute = routes.get(source);
        DefaultRoute<V, Edge> newRoute = new DefaultRoute<V, Edge>(sourceRoute.getSourceVertex(), target);
        newRoute.addAll(sourceRoute);
        newRoute.add(edge);
        routes.put(target, newRoute);
    }

    protected static <V> void sortVertecesByCost(List<V> vertexList, Map<V, Double> costs) {
        Collections.sort(vertexList, new DistComparator<V>(costs));
    }

    protected static final class DistComparator<V>
    implements Comparator<V> {
        protected final Map<V, Double> _costs;

        public DistComparator(Map<V, Double> costs) {
            this._costs = costs;
        }

        @Override
        public int compare(V v1, V v2) {
            Double d1 = this._costs.get(v1);
            Double d2 = this._costs.get(v2);
            if (d1 == null) {
                return d2 == null ? 0 : 1;
            }
            if (d2 == null) {
                return -1;
            }
            return d1.compareTo(d2);
        }
    }
}

