/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class FileUtils {
    public static List<String> getPathSegments(File file) {
        List<String> segements = Arrays.asList(file.getAbsoluteFile().toURI().getPath().split("/"));
        return segements.subList(1, segements.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getChecksum(File file) {
        if (file.isDirectory()) {
            return 0L;
        }
        FilterInputStream cis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(file), new Adler32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            long l = ((CheckedInputStream)cis).getChecksum().getValue();
            return l;
        }
        catch (IOException e) {
            long l = 0L;
            return l;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

