/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.io.folderdiff;

import java.io.File;
import java.util.List;
import net.sf.javagimmicks.io.FileUtils;
import net.sf.javagimmicks.io.folderdiff.PathInfo;

public class FileInfo {
    private final File _file;
    private long _checkSum;
    private final PathInfo _pathInfo;

    FileInfo(File file, int skipFragments) {
        this._file = file;
        this._pathInfo = new PathInfo(file, skipFragments);
    }

    public List<String> getPathFragments() {
        return this._pathInfo.getPathFragments();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public long getSize() {
        return this._file.length();
    }

    public long getLastModified() {
        return this._file.lastModified();
    }

    public long getChecksum() {
        if (this.isDirectory()) {
            return 0L;
        }
        if (this._checkSum == 0L) {
            this._checkSum = FileUtils.getChecksum(this._file);
        }
        return this._checkSum;
    }

    public File getOriginalFile() {
        return this._file;
    }

    public PathInfo getPathInfo() {
        return this._pathInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        return this._pathInfo.equals(((FileInfo)o)._pathInfo);
    }
}

