/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.io.folderdiff;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.javagimmicks.collections.ListComparator;
import net.sf.javagimmicks.io.folderdiff.FileInfo;
import net.sf.javagimmicks.io.folderdiff.FolderDiffListener;
import net.sf.javagimmicks.io.folderdiff.PathInfo;
import net.sf.javagimmicks.math.NumberCompareUtils;
import net.sf.javagimmicks.math.comparator.LongComparator;
import net.sf.javagimmicks.util.CompositeComparator;

class FileInfoComparatorBuilder {
    private boolean _comparePaths = true;
    private boolean _compareSize = false;
    private boolean _compareLastModified = false;
    private boolean _compareChecksum = false;
    private FolderDiffListener _listener;
    private static final LongComparator LONG_COMPARATOR = NumberCompareUtils.getLongComparator();
    private static final ListComparator<String> STRING_LIST_COMPARATOR;
    public static final Comparator<FileInfo> CHECKSUM_COMPARATOR;
    public static final Comparator<FileInfo> LAST_MOD_COMPARATOR;
    public static final Comparator<FileInfo> SIZE_COMPARATOR;
    public static final Comparator<PathInfo> PATH_INFO_COMPARATOR;
    public static final Comparator<FileInfo> PATH_COMPARATOR;

    FileInfoComparatorBuilder() {
    }

    public static Comparator<FileInfo> getPathOnlyInstance() {
        return new FileInfoComparatorBuilder().buildComparator();
    }

    public static Comparator<FileInfo> getPathAndSizeInstance() {
        return new FileInfoComparatorBuilder().setCompareSize(true).buildComparator();
    }

    public static Comparator<FileInfo> getPathAndLastModifiedInstance() {
        return new FileInfoComparatorBuilder().setCompareLastModified(true).buildComparator();
    }

    public static Comparator<FileInfo> getPathAndSizeAndLastModifiedInstance() {
        return new FileInfoComparatorBuilder().setCompareLastModified(true).setCompareSize(true).buildComparator();
    }

    public Comparator<FileInfo> buildComparator() {
        ArrayList<Comparator<Comparator<FileInfo>>> comparators = new ArrayList<Comparator<Comparator<FileInfo>>>();
        if (this._compareSize) {
            comparators.add(SIZE_COMPARATOR);
        }
        if (this._compareLastModified) {
            comparators.add(LAST_MOD_COMPARATOR);
        }
        if (this._comparePaths) {
            comparators.add(PATH_COMPARATOR);
        }
        if (this._compareChecksum) {
            comparators.add(CHECKSUM_COMPARATOR);
        }
        CompositeComparator<FileInfo> actualComparator = new CompositeComparator<FileInfo>(comparators);
        return this._listener == null ? actualComparator : new EventFileInfoComparator(actualComparator, this._listener);
    }

    public void setFolderDiffListener(FolderDiffListener listener) {
        this._listener = listener;
    }

    public boolean isComparePaths() {
        return this._comparePaths;
    }

    public boolean isCompareSize() {
        return this._compareSize;
    }

    public boolean isCompareLastModified() {
        return this._compareLastModified;
    }

    public boolean isCompareChecksum() {
        return this._compareChecksum;
    }

    public FileInfoComparatorBuilder setComparePaths(boolean comparePaths) {
        this._comparePaths = comparePaths;
        return this;
    }

    public FileInfoComparatorBuilder setCompareSize(boolean compareSize) {
        this._compareSize = compareSize;
        return this;
    }

    public FileInfoComparatorBuilder setCompareLastModified(boolean compareLastModified) {
        this._compareLastModified = compareLastModified;
        return this;
    }

    public void setCompareChecksum(boolean compareChecksum) {
        this._compareChecksum = compareChecksum;
    }

    static {
        ListComparator<? extends Comparable<?>> c = ListComparator.COMPARABLE_INSTANCE;
        STRING_LIST_COMPARATOR = c;
        CHECKSUM_COMPARATOR = new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                return LONG_COMPARATOR.compare(o1.getChecksum(), o2.getChecksum());
            }
        };
        LAST_MOD_COMPARATOR = new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                if (o1.isDirectory() && o2.isDirectory()) {
                    return 0;
                }
                if (o1.isDirectory()) {
                    return -1;
                }
                if (o2.isDirectory()) {
                    return 1;
                }
                return LONG_COMPARATOR.compare(o1.getLastModified(), o2.getLastModified());
            }
        };
        SIZE_COMPARATOR = new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                return LONG_COMPARATOR.compare(o1.getSize(), o2.getSize());
            }
        };
        PATH_INFO_COMPARATOR = new Comparator<PathInfo>(){

            @Override
            public int compare(PathInfo o1, PathInfo o2) {
                List<String> pathFragments1 = o1.getPathFragments();
                List<String> pathFragments2 = o2.getPathFragments();
                int size1 = pathFragments1.size();
                int size2 = pathFragments2.size();
                if (size1 == 0 && size2 == 0) {
                    return 0;
                }
                if (size1 == 0) {
                    return -1;
                }
                if (size2 == 0) {
                    return 1;
                }
                List<String> parentPath1 = pathFragments1.subList(0, size1 - 1);
                List<String> parentPath2 = pathFragments2.subList(0, size2 - 1);
                int parentCompare = STRING_LIST_COMPARATOR.compare(parentPath1, parentPath2);
                if (parentCompare != 0) {
                    return parentCompare;
                }
                boolean isDirectory1 = o1.isDirectory();
                if (isDirectory1 != o2.isDirectory()) {
                    return isDirectory1 ? -1 : 1;
                }
                return pathFragments1.get(size1 - 1).compareTo(pathFragments2.get(size2 - 1));
            }
        };
        PATH_COMPARATOR = new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                return PATH_INFO_COMPARATOR.compare(o1.getPathInfo(), o2.getPathInfo());
            }
        };
    }

    private static final class EventFileInfoComparator
    implements Comparator<FileInfo> {
        private final Comparator<FileInfo> _baseComparator;
        private final FolderDiffListener _listener;

        public EventFileInfoComparator(Comparator<FileInfo> comparator, FolderDiffListener listener) {
            this._baseComparator = comparator;
            this._listener = listener;
        }

        @Override
        public int compare(FileInfo o1, FileInfo o2) {
            this._listener.fileInfosCompared(o1, o2);
            return this._baseComparator.compare(o1, o2);
        }
    }
}

