/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.io.folderdiff;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import net.sf.javagimmicks.io.FileUtils;
import net.sf.javagimmicks.io.folderdiff.FileInfo;
import net.sf.javagimmicks.io.folderdiff.FolderDiffListener;

class FileScanner {
    private final FilenameFilter _filter;
    private final File _rootFile;
    private final boolean _recursive;
    private FolderDiffListener _listener;

    public FileScanner(File rootFile, FilenameFilter filter, boolean recursive) {
        if (rootFile == null) {
            throw new IllegalArgumentException("Root file may not be null!");
        }
        this._rootFile = rootFile;
        this._filter = filter;
        this._recursive = recursive;
    }

    public void setFolderDiffListener(FolderDiffListener listener) {
        this._listener = listener;
    }

    public List<FileInfo> scan() {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        if (this._rootFile.isDirectory()) {
            int skipSegments = FileUtils.getPathSegments(this._rootFile).size();
            this.scanInternal(result, this._rootFile, skipSegments);
        }
        return result;
    }

    private void scanInternal(List<FileInfo> result, File currentDir, int skipSegments) {
        File[] children;
        if (this._listener != null) {
            this._listener.folderScanned(currentDir);
        }
        for (File child : children = currentDir.listFiles(this._filter)) {
            if (!child.isDirectory()) continue;
            result.add(new FileInfo(child, skipSegments));
            if (!this._recursive) continue;
            this.scanInternal(result, child, skipSegments);
        }
        for (File childFile : children) {
            if (childFile.isDirectory()) continue;
            result.add(new FileInfo(childFile, skipSegments));
        }
    }
}

