/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.io.folderdiff;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.javagimmicks.collections.CollectionDifference;
import net.sf.javagimmicks.collections.diff.Difference;
import net.sf.javagimmicks.collections.diff.DifferenceList;
import net.sf.javagimmicks.collections.diff.DifferenceUtils;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils;
import net.sf.javagimmicks.io.folderdiff.FileInfo;
import net.sf.javagimmicks.io.folderdiff.FileInfoComparatorBuilder;
import net.sf.javagimmicks.io.folderdiff.FileScanner;
import net.sf.javagimmicks.io.folderdiff.FolderDiff;
import net.sf.javagimmicks.io.folderdiff.FolderDiffListener;
import net.sf.javagimmicks.io.folderdiff.IncludeExcludeFilenameFilter;
import net.sf.javagimmicks.io.folderdiff.PathInfo;

public class FolderDiffBuilder {
    private final Comparator<PathInfo> PATH_COMPARATOR = FileInfoComparatorBuilder.PATH_INFO_COMPARATOR;
    private final File _sourceFolder;
    private final Collection<String> _sourceIncludes = new TreeSet<String>();
    private final Collection<String> _sourceExcludes = new TreeSet<String>();
    private final File _targetFolder;
    private final Collection<String> _targetIncludes = new TreeSet<String>();
    private final Collection<String> _targetExcludes = new TreeSet<String>();
    private final FileInfoComparatorBuilder _comparatorBuilder = new FileInfoComparatorBuilder();
    private boolean _recursive;
    private FolderDiffListener _listener;
    private static final Transformer<FileInfo, PathInfo> FILE_TO_PATH_INFO = new Transformer<FileInfo, PathInfo>(){

        @Override
        public PathInfo transform(FileInfo source) {
            return source.getPathInfo();
        }
    };

    public FolderDiffBuilder(File sourceFolder, File targetFolder, boolean recursive) {
        this._sourceFolder = sourceFolder;
        this._targetFolder = targetFolder;
        this._recursive = recursive;
    }

    public FolderDiffBuilder(File sourceFolder, File targetFolder) {
        this(sourceFolder, targetFolder, true);
    }

    public FolderDiff buildFolderDiff() {
        IncludeExcludeFilenameFilter sourceFilter = new IncludeExcludeFilenameFilter(this._sourceIncludes, this._sourceExcludes);
        FileScanner sourceScanner = new FileScanner(this._sourceFolder, sourceFilter, this._recursive);
        if (this._listener != null) {
            sourceScanner.setFolderDiffListener(this._listener);
        }
        List<FileInfo> sourceFiles = sourceScanner.scan();
        IncludeExcludeFilenameFilter targetFilter = new IncludeExcludeFilenameFilter(this._targetIncludes, this._targetExcludes);
        FileScanner targetScanner = new FileScanner(this._targetFolder, targetFilter, this._recursive);
        if (this._listener != null) {
            targetScanner.setFolderDiffListener(this._listener);
        }
        List<FileInfo> targetFiles = targetScanner.scan();
        TreeSet<PathInfo> filesAll = new TreeSet<PathInfo>(this.PATH_COMPARATOR);
        filesAll.addAll(FolderDiffBuilder.getPathInfoCollection(sourceFiles));
        filesAll.addAll(FolderDiffBuilder.getPathInfoCollection(targetFiles));
        DifferenceList<FileInfo> differences = DifferenceUtils.findDifferences(sourceFiles, targetFiles, this._comparatorBuilder.buildComparator());
        TreeSet<PathInfo> filesDifferent = new TreeSet<PathInfo>(this.PATH_COMPARATOR);
        TreeSet<PathInfo> filesSourceOnly = new TreeSet<PathInfo>(this.PATH_COMPARATOR);
        TreeSet<PathInfo> filesTargetOnly = new TreeSet<PathInfo>(this.PATH_COMPARATOR);
        for (Difference difference : differences) {
            List listDelete = difference.getDeleteList();
            List listAdd = difference.getAddList();
            CollectionDifference collectionDifference = new CollectionDifference(listDelete, listAdd);
            filesDifferent.addAll(FolderDiffBuilder.getPathInfoCollection(collectionDifference.getBoth()));
            filesSourceOnly.addAll(FolderDiffBuilder.getPathInfoCollection(collectionDifference.getOnlyA()));
            filesTargetOnly.addAll(FolderDiffBuilder.getPathInfoCollection(collectionDifference.getOnlyB()));
        }
        TreeSet<PathInfo> filesEqual = new TreeSet<PathInfo>((SortedSet<PathInfo>)filesAll);
        filesEqual.removeAll(filesDifferent);
        filesEqual.removeAll(filesSourceOnly);
        filesEqual.removeAll(filesTargetOnly);
        return new FolderDiff(this._sourceFolder, this._targetFolder, filesAll, filesEqual, filesDifferent, filesSourceOnly, filesTargetOnly);
    }

    public File getSourceFolder() {
        return this._sourceFolder;
    }

    public Collection<String> getSourceIncludes() {
        return this._sourceIncludes;
    }

    public Collection<String> getSourceExcludes() {
        return this._sourceExcludes;
    }

    public File getTargetFolder() {
        return this._targetFolder;
    }

    public Collection<String> getTargetIncludes() {
        return this._targetIncludes;
    }

    public Collection<String> getTargetExcludes() {
        return this._targetExcludes;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public boolean isCompareChecksum() {
        return this._comparatorBuilder.isCompareChecksum();
    }

    public boolean isCompareLastModified() {
        return this._comparatorBuilder.isCompareLastModified();
    }

    public boolean isCompareSize() {
        return this._comparatorBuilder.isCompareSize();
    }

    public FolderDiffBuilder addSourceInclude(String pattern) {
        this._sourceIncludes.add(pattern);
        return this;
    }

    public FolderDiffBuilder addSourceExclude(String pattern) {
        this._sourceExcludes.add(pattern);
        return this;
    }

    public FolderDiffBuilder addTargetInclude(String pattern) {
        this._targetIncludes.add(pattern);
        return this;
    }

    public FolderDiffBuilder addTargetExclude(String pattern) {
        this._targetExcludes.add(pattern);
        return this;
    }

    public FolderDiffBuilder addSourceIncludes(Collection<String> patterns) {
        this._sourceIncludes.addAll(patterns);
        return this;
    }

    public FolderDiffBuilder addSourceExcludes(Collection<String> patterns) {
        this._sourceExcludes.addAll(patterns);
        return this;
    }

    public FolderDiffBuilder addTargetIncludes(Collection<String> patterns) {
        this._targetIncludes.addAll(patterns);
        return this;
    }

    public FolderDiffBuilder addTargetExcludes(Collection<String> patterns) {
        this._targetExcludes.addAll(patterns);
        return this;
    }

    public FolderDiffBuilder setRecursive(boolean recursive) {
        this._recursive = recursive;
        return this;
    }

    public FolderDiffBuilder setCompareChecksum(boolean compareChecksum) {
        this._comparatorBuilder.setCompareChecksum(compareChecksum);
        return this;
    }

    public FolderDiffBuilder setCompareLastModified(boolean compareLastModified) {
        this._comparatorBuilder.setCompareLastModified(compareLastModified);
        return this;
    }

    public FolderDiffBuilder setCompareSize(boolean compareSize) {
        this._comparatorBuilder.setCompareSize(compareSize);
        return this;
    }

    public FolderDiffBuilder reset() {
        this._sourceIncludes.clear();
        this._sourceExcludes.clear();
        this._targetIncludes.clear();
        this._targetExcludes.clear();
        this.setCompareChecksum(false);
        this.setCompareLastModified(false);
        this.setCompareSize(false);
        this.setRecursive(true);
        return this;
    }

    public FolderDiffBuilder setFolderDiffListener(FolderDiffListener listener) {
        this._listener = listener;
        this._comparatorBuilder.setFolderDiffListener(listener);
        return this;
    }

    private static Collection<PathInfo> getPathInfoCollection(Collection<FileInfo> collection) {
        return TransformerUtils.decorate(collection, FILE_TO_PATH_INFO);
    }
}

