/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.io.folderdiff;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils;
import net.sf.javagimmicks.util.IncludeExcludePatternFilter;

class IncludeExcludeFilenameFilter
implements FilenameFilter {
    private final IncludeExcludePatternFilter _filter = new IncludeExcludePatternFilter();
    private static final Transformer<String, String> _patternTransformer = new Transformer<String, String>(){

        @Override
        public String transform(String source) {
            return source.replaceAll("\\.", "\\.").replaceAll("\\*", ".*").replaceAll("\\?", ".");
        }
    };

    public IncludeExcludeFilenameFilter(Collection<String> includePatterns, Collection<String> excludePatterns) {
        this.addIncludePatterns(includePatterns);
        this.addExcludePatterns(excludePatterns);
    }

    public IncludeExcludeFilenameFilter(Collection<String> excludePatterns) {
        this.addExcludePatterns(excludePatterns);
    }

    public IncludeExcludeFilenameFilter(String includePattern, String excludePattern) {
        this.addIncludePattern(includePattern);
        this.addExcludePattern(excludePattern);
    }

    public IncludeExcludeFilenameFilter(String excludePattern) {
        this.addExcludePattern(excludePattern);
    }

    public IncludeExcludeFilenameFilter() {
    }

    @Override
    public boolean accept(File dir, String name) {
        return this._filter.accepts(name);
    }

    public void addIncludePattern(String pattern) {
        this._filter.addIncludePatternString(_patternTransformer.transform(pattern));
    }

    public void addIncludePatterns(Collection<String> patterns) {
        this._filter.addIncludePatternStrings(TransformerUtils.decorate(patterns, _patternTransformer));
    }

    public void addExcludePattern(String pattern) {
        this._filter.addExcludePatternString(_patternTransformer.transform(pattern));
    }

    public void addExcludePatterns(Collection<String> patterns) {
        this._filter.addExcludePatternStrings(TransformerUtils.decorate(patterns, _patternTransformer));
    }
}

