/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.javagimmicks.lang.Factory;

public class PrototypeFactory<E extends Cloneable>
implements Factory<E> {
    protected final E _prototype;
    protected final Method _cloneMethod;

    public PrototypeFactory(E prototype) {
        if (prototype == null) {
            throw new IllegalArgumentException("Prototype may not be null!");
        }
        this._prototype = prototype;
        try {
            this._cloneMethod = this._prototype.getClass().getMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot access clone() method of given prototype!");
        }
        if (!this._cloneMethod.isAccessible()) {
            this._cloneMethod.setAccessible(true);
        }
        if (!Modifier.isPublic(this._cloneMethod.getModifiers())) {
            throw new IllegalArgumentException("clone() method of given prototype is not public!");
        }
    }

    @Override
    public E create() {
        try {
            return (E)((Cloneable)this._cloneMethod.invoke(this._prototype, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("The invoked clone() method is not accessible", e);
        }
        catch (InvocationTargetException e) {
            Throwable originalThrowable = e.getTargetException();
            if (originalThrowable instanceof Error) {
                throw (Error)originalThrowable;
            }
            if (originalThrowable instanceof RuntimeException) {
                throw (RuntimeException)originalThrowable;
            }
            return null;
        }
    }
}

