/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.sf.javagimmicks.lang.Factory;

public class ReflectionFactory<E>
implements Factory<E> {
    protected final Constructor<? extends E> _constructor;
    protected final Factory<Object[]> _argFactory;
    private static final Factory<Object[]> EMPTY_ARG_FACTORY = new Factory<Object[]>(){

        @Override
        public Object[] create() {
            return new Object[0];
        }
    };

    public ReflectionFactory(Constructor<? extends E> constructor, Factory<Object[]> argFactory) throws IllegalArgumentException, SecurityException {
        Class<E> declaringClass = constructor.getDeclaringClass();
        if (Modifier.isAbstract(declaringClass.getModifiers())) {
            throw new IllegalArgumentException("The given contructor belongs to an abstract class: " + declaringClass.getName());
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new IllegalArgumentException("Contructor must be public and accessible!");
        }
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        for (Class<?> exceptionClass : constructor.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exceptionClass) || Error.class.isAssignableFrom(exceptionClass)) continue;
            throw new IllegalArgumentException("The given constructor throws and Exception of type " + exceptionClass + " which is a checked Exception!");
        }
        this._constructor = constructor;
        this._argFactory = argFactory != null ? argFactory : EMPTY_ARG_FACTORY;
    }

    public ReflectionFactory(Class<? extends E> type, Class<?>[] argTypes, Factory<Object[]> argFactory) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        this(type.getConstructor(argTypes), argFactory);
    }

    public ReflectionFactory(Class<? extends E> type) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        this(type, new Class[0], null);
    }

    @Override
    public final E create() {
        try {
            return this._constructor.newInstance(this._argFactory.create());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("The invoked clone() method is not accessible", e);
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable originalThrowable = e.getTargetException();
            if (originalThrowable instanceof Error) {
                throw (Error)originalThrowable;
            }
            if (originalThrowable instanceof RuntimeException) {
                throw (RuntimeException)originalThrowable;
            }
            return null;
        }
    }
}

