/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.math;

import java.math.BigInteger;
import java.util.Collection;
import net.sf.javagimmicks.math.CombinatoricOperator;

public class Combinator<T>
extends CombinatoricOperator<T> {
    public Combinator(T[] elements, int r) {
        super(elements, r);
        assert (r <= elements.length);
    }

    public Combinator(Collection<T> elements, int r) {
        super(elements, r);
        if (r > elements.size()) {
            throw new IllegalArgumentException("Size of lists to create mustn't be greater than number of provided elements!");
        }
    }

    @Override
    protected BigInteger initialiseTotal(int n, int r) {
        BigInteger nFact = Combinator.factorial(n);
        BigInteger rFact = Combinator.factorial(r);
        BigInteger nminusrFact = Combinator.factorial(n - r);
        return nFact.divide(rFact.multiply(nminusrFact));
    }

    @Override
    protected void computeNext() {
        int r = this.indices.length;
        int i = r - 1;
        int n = this.elements.size();
        while (this.indices[i] == n - r + i) {
            --i;
        }
        this.indices[i] = this.indices[i] + 1;
        for (int j = i + 1; j < r; ++j) {
            this.indices[j] = this.indices[i] + j - i;
        }
    }
}

