/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.math;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class CombinatoricOperator<T>
implements Iterator<ArrayList<T>>,
Iterable<ArrayList<T>> {
    protected List<T> elements;
    protected int[] indices;
    private BigInteger numLeft;
    private BigInteger total;

    protected CombinatoricOperator(T[] elements, int r) {
        this(Arrays.asList(elements), r);
    }

    protected CombinatoricOperator(Collection<T> elements, int r) {
        if (r < 0) {
            throw new IllegalArgumentException("Size of lists to create must at least 0!");
        }
        this.indices = new int[r];
        this.elements = new ArrayList<T>(elements);
        this.total = this.initialiseTotal(elements.size(), r);
        this.reset();
    }

    protected void initialiseIndices() {
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = i;
        }
    }

    protected abstract BigInteger initialiseTotal(int var1, int var2);

    public void reset() {
        this.initialiseIndices();
        this.numLeft = this.total;
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    @Override
    public boolean hasNext() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    @Override
    public ArrayList<T> next() {
        if (!this.numLeft.equals(this.total)) {
            this.computeNext();
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.getResult(this.indices);
    }

    protected abstract void computeNext();

    private ArrayList<T> getResult(int[] indexes) {
        ArrayList<T> result = new ArrayList<T>(indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            result.add(this.elements.get(indexes[i]));
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ArrayList<T>> iterator() {
        return this;
    }

    public static BigInteger factorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(BigInteger.valueOf(i));
        }
        return fact;
    }
}

