/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.math;

import java.math.BigInteger;
import java.util.Collection;
import net.sf.javagimmicks.math.CombinatoricOperator;

public class Permuter<T>
extends CombinatoricOperator<T> {
    public Permuter(T[] elements) {
        super(elements, elements.length);
    }

    public Permuter(Collection<T> elements) {
        super(elements, elements.size());
    }

    @Override
    protected BigInteger initialiseTotal(int n, int r) {
        return Permuter.factorial(n);
    }

    @Override
    protected void computeNext() {
        int i = this.indices.length - 1;
        while (this.indices[i - 1] >= this.indices[i]) {
            --i;
        }
        int j = this.indices.length;
        while (this.indices[j - 1] <= this.indices[i - 1]) {
            --j;
        }
        this.swap(i - 1, j - 1);
        ++i;
        for (j = this.indices.length; i < j; ++i, --j) {
            this.swap(i - 1, j - 1);
        }
    }

    private void swap(int a, int b) {
        int temp = this.indices[a];
        this.indices[a] = this.indices[b];
        this.indices[b] = temp;
    }
}

