/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.math;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import net.sf.javagimmicks.math.CombinatoricOperator;

public class VariatorWithRepetition<T>
extends CombinatoricOperator<T> {
    public VariatorWithRepetition(T[] elements, int r) {
        super(elements, r);
    }

    public VariatorWithRepetition(Collection<T> elements, int r) {
        super(elements, r);
    }

    @Override
    protected void initialiseIndices() {
        Arrays.fill(this.indices, 0);
    }

    @Override
    protected BigInteger initialiseTotal(int n, int r) {
        return BigInteger.valueOf(n).pow(r);
    }

    @Override
    protected void computeNext() {
        int i = this.indices.length - 1;
        int n = this.elements.size();
        while (true) {
            int n2 = i;
            this.indices[n2] = this.indices[n2] + 1;
            if (this.indices[n2] != n || i <= 0) break;
            this.indices[i--] = 0;
        }
    }
}

