/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.sf.javagimmicks.swing.MarkOnFocusListener;

public class AutoComboBoxEditor
extends BasicComboBoxEditor {
    private final JComboBox _comboBox;
    private boolean _caseSensitive = false;
    private boolean _strict = true;
    private MarkOnFocusListener _markOnFocusListener;

    public static void install(JComboBox comboBox, boolean markOnFocus, boolean caseSensitive, boolean strict) {
        AutoComboBoxEditor editor = new AutoComboBoxEditor(comboBox);
        editor.setCaseSensitive(caseSensitive);
        editor.setStrict(strict);
        editor.setMarkOnFocus(markOnFocus);
        comboBox.setEditor(editor);
        comboBox.setEditable(true);
    }

    public static void install(JComboBox comboBox, boolean markOnFocus, boolean caseSensitive) {
        AutoComboBoxEditor.install(comboBox, markOnFocus, caseSensitive, true);
    }

    public static void install(JComboBox comboBox, boolean markOnFocus) {
        AutoComboBoxEditor.install(comboBox, markOnFocus, false);
    }

    public static void install(JComboBox comboBox) {
        AutoComboBoxEditor.install(comboBox, false);
    }

    public AutoComboBoxEditor(JComboBox comboBox) {
        this._comboBox = comboBox;
        this.editor = new AutoTextField();
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public boolean isMarkOnFocus() {
        return this._markOnFocusListener != null;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public void setMarkOnFocus(boolean markOnFocus) {
        if (markOnFocus == this.isMarkOnFocus()) {
            return;
        }
        if (markOnFocus) {
            this._markOnFocusListener = new MarkOnFocusListener(this.editor);
            this.editor.addFocusListener(this._markOnFocusListener);
        } else {
            this.editor.removeFocusListener(this._markOnFocusListener);
            this._markOnFocusListener = null;
        }
    }

    private ComboBoxModel getModel() {
        return this._comboBox.getModel();
    }

    private class AutoTextField
    extends JTextField {
        private static final long serialVersionUID = -2404637927639461570L;

        public AutoTextField() {
            this.setDocument(new AutoDocument());
            this.setBorder(null);
            if (AutoComboBoxEditor.this._strict && AutoComboBoxEditor.this.getModel().getSize() > 0) {
                this.setText(AutoComboBoxEditor.this.getModel().getElementAt(0).toString());
            }
        }

        @Override
        public void replaceSelection(String sText) {
            AutoDocument oAutoDocument = (AutoDocument)this.getDocument();
            if (oAutoDocument != null) {
                try {
                    int iStart = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
                    int iEnd = Math.max(this.getCaret().getDot(), this.getCaret().getMark());
                    oAutoDocument.replace(iStart, iEnd - iStart, sText, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private String getMatch(String sText) {
            for (int i = 0; i < AutoComboBoxEditor.this.getModel().getSize(); ++i) {
                String sListEntry = AutoComboBoxEditor.this.getModel().getElementAt(i).toString();
                if (sListEntry == null) continue;
                if (!AutoComboBoxEditor.this._caseSensitive && sListEntry.toLowerCase().startsWith(sText.toLowerCase())) {
                    return sListEntry;
                }
                if (!AutoComboBoxEditor.this._caseSensitive || !sListEntry.startsWith(sText)) continue;
                return sListEntry;
            }
            return null;
        }

        private class AutoDocument
        extends PlainDocument {
            private static final long serialVersionUID = -7796598731233922182L;

            private AutoDocument() {
            }

            @Override
            public void replace(int iOffset, int iLength, String sText, AttributeSet oAttributeSet) throws BadLocationException {
                super.remove(iOffset, iLength);
                this.insertString(iOffset, sText, oAttributeSet);
            }

            @Override
            public void insertString(int iOffset, String sText, AttributeSet oAttributeSet) throws BadLocationException {
                if (sText == null || "".equals(sText)) {
                    return;
                }
                String sStart = this.getText(0, iOffset);
                String sMatch = AutoTextField.this.getMatch(sStart + sText);
                int iLength = iOffset + sText.length() - 1;
                if (AutoComboBoxEditor.this._strict && sMatch == null) {
                    sMatch = AutoTextField.this.getMatch(sStart);
                    --iLength;
                } else if (!AutoComboBoxEditor.this._strict && sMatch == null) {
                    super.insertString(iOffset, sText, oAttributeSet);
                    return;
                }
                if (sMatch != null) {
                    AutoComboBoxEditor.this.getModel().setSelectedItem(sMatch);
                }
                super.remove(0, this.getLength());
                super.insertString(0, sMatch, oAttributeSet);
                AutoTextField.this.setSelectionStart(iLength + 1);
                AutoTextField.this.setSelectionEnd(this.getLength());
            }

            @Override
            public void remove(int iOffset, int iLength) throws BadLocationException {
                int iStart = AutoTextField.this.getSelectionStart();
                if (iStart > 0) {
                    --iStart;
                }
                String sMatch = AutoTextField.this.getMatch(this.getText(0, iStart));
                if (!AutoComboBoxEditor.this._strict && sMatch == null) {
                    super.remove(iOffset, iLength);
                } else {
                    super.remove(0, this.getLength());
                    super.insertString(0, sMatch, null);
                }
                if (sMatch != null) {
                    AutoComboBoxEditor.this.getModel().setSelectedItem(sMatch);
                }
                try {
                    AutoTextField.this.setSelectionStart(iStart);
                    AutoTextField.this.setSelectionEnd(this.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

