/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;

public class BackgroundImageHelper {
    private boolean _enlarge = false;
    private int _scaleHint = 1;
    private boolean _keepRatio = true;
    private final Image _image;
    private final int _imageWidth;
    private final int _imageHeight;
    private final double _imageRatio;
    private Image _scaledImage;
    private int _scaledWith;
    private int _scaledHeight;
    private boolean _drawScaled = false;
    private int _lastWidth;
    private int _lastHeight;

    public BackgroundImageHelper(Image image) {
        this._image = image;
        this._imageWidth = image.getWidth(null);
        this._imageHeight = image.getHeight(null);
        this._imageRatio = (double)this._imageWidth / (double)this._imageHeight;
    }

    public boolean isEnlarge() {
        return this._enlarge;
    }

    public void setEnlarge(boolean enlarge) {
        this._enlarge = enlarge;
    }

    public int getScaleHint() {
        return this._scaleHint;
    }

    public void setScaleHint(int scaleHint) {
        this._scaleHint = scaleHint;
    }

    public boolean isKeepRatio() {
        return this._keepRatio;
    }

    public void setKeepRatio(boolean keepRatio) {
        this._keepRatio = keepRatio;
    }

    public void paintComponent(Component component, Graphics g) {
        int width = component.getWidth();
        int height = component.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        this.recalc(width, height);
        if (this._drawScaled) {
            int x = (this._lastWidth - this._scaledWith) / 2;
            int y = (this._lastHeight - this._scaledHeight) / 2;
            g.drawImage(this._scaledImage, x, y, this._scaledWith, this._scaledHeight, component);
        } else {
            int x = (this._lastWidth - this._imageWidth) / 2;
            int y = (this._lastHeight - this._imageHeight) / 2;
            g.drawImage(this._image, x, y, this._imageWidth, this._imageHeight, component);
        }
    }

    private void recalc(int newWidth, int newHeight) {
        int newScaledHeight;
        int newScaledWith;
        if (newWidth == this._lastWidth && newHeight == this._lastHeight) {
            return;
        }
        this._lastWidth = newWidth;
        this._lastHeight = newHeight;
        double currentRatio = (double)this._lastWidth / (double)this._lastHeight;
        if (this._keepRatio) {
            if (currentRatio >= this._imageRatio) {
                newScaledWith = (int)((double)this._lastHeight * this._imageRatio);
                newScaledHeight = this._lastHeight;
            } else {
                newScaledHeight = (int)((double)this._lastWidth / this._imageRatio);
                newScaledWith = this._lastWidth;
            }
        } else {
            newScaledHeight = this._lastHeight;
            newScaledWith = this._lastWidth;
        }
        newScaledHeight = this._enlarge ? newScaledHeight : Math.min(newScaledHeight, this._imageHeight);
        int n = newScaledWith = this._enlarge ? newScaledWith : Math.min(newScaledWith, this._imageWidth);
        if (newScaledHeight == this._imageHeight && newScaledWith == this._imageWidth) {
            this._drawScaled = false;
        } else {
            if (newScaledHeight != this._scaledHeight || newScaledWith != this._scaledWith) {
                this._scaledHeight = newScaledHeight;
                this._scaledWith = newScaledWith;
                this._scaledImage = this._image.getScaledInstance(this._scaledWith, this._scaledHeight, this._scaleHint);
            }
            this._drawScaled = true;
        }
    }
}

