/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import net.sf.javagimmicks.collections.AutoSkippingQueueDecorator;

public class BoundedEventQueue {
    private final AutoSkippingQueueDecorator<Runnable> _internalQueue;
    private WorkerThread _workerThread;

    public BoundedEventQueue(int maxSize, int skipCount) {
        this._internalQueue = new AutoSkippingQueueDecorator(maxSize, skipCount);
    }

    public BoundedEventQueue(int maxSize) {
        this._internalQueue = new AutoSkippingQueueDecorator(maxSize);
    }

    public void startWorking() {
        if (this._workerThread == null || !this._workerThread.isAlive()) {
            this._workerThread = new WorkerThread();
            this._workerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorking() {
        if (this._workerThread != null && this._workerThread.isAlive()) {
            this._workerThread.interrupt();
            this._workerThread = null;
        }
        AutoSkippingQueueDecorator<Runnable> autoSkippingQueueDecorator = this._internalQueue;
        synchronized (autoSkippingQueueDecorator) {
            this._internalQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Runnable action) {
        AutoSkippingQueueDecorator<Runnable> autoSkippingQueueDecorator = this._internalQueue;
        synchronized (autoSkippingQueueDecorator) {
            this._internalQueue.offer(action);
            this._internalQueue.notify();
        }
    }

    protected void finalize() throws Throwable {
        this.stopWorking();
    }

    private class WorkerThread
    extends Thread {
        public WorkerThread() {
            super("BoundedEventQueue_Worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                Runnable action;
                AutoSkippingQueueDecorator autoSkippingQueueDecorator = BoundedEventQueue.this._internalQueue;
                synchronized (autoSkippingQueueDecorator) {
                    while (BoundedEventQueue.this._internalQueue.isEmpty()) {
                        try {
                            BoundedEventQueue.this._internalQueue.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    action = (Runnable)BoundedEventQueue.this._internalQueue.poll();
                }
                try {
                    SwingUtilities.invokeAndWait(action);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                }
            }
        }
    }
}

