/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.javagimmicks.swing.controller.AbstractKeyAcceleratorAction;

public class JMenuBuilder {
    private final Stack<JMenu> _subMenuStack = new Stack();
    private final List<JMenuItem> _topLevelItems = new ArrayList<JMenuItem>();

    public JMenuBuilder menu(String menuName) {
        JMenu menu = new JMenu(menuName);
        this.add(menu);
        this._subMenuStack.push(menu);
        return this;
    }

    public JMenuBuilder item(Action action) {
        JMenuItem item = new JMenuItem(action);
        this.add(item);
        return this;
    }

    public JMenuBuilder item(String name, final ActionListener listener) {
        return this.item(new AbstractAction(name){
            private static final long serialVersionUID = -1845717164976373485L;

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.actionPerformed(e);
            }
        });
    }

    public JMenuBuilder item(String name, final ActionListener listener, int keyCode) {
        return this.item(new AbstractKeyAcceleratorAction(name, keyCode){
            private static final long serialVersionUID = -1845717164976373484L;

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.actionPerformed(e);
            }
        });
    }

    public JMenuBuilder item(String same, final ActionListener listener, int keyCode, int modifiers) {
        return this.item(new AbstractKeyAcceleratorAction(same, keyCode, modifiers){
            private static final long serialVersionUID = -1845717164976373483L;

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.actionPerformed(e);
            }
        });
    }

    public JMenuBuilder separator() {
        if (this._subMenuStack.isEmpty()) {
            throw new IllegalStateException("Cannot add separator on the top level!");
        }
        this._subMenuStack.peek().addSeparator();
        return this;
    }

    public JMenuBuilder parent() {
        if (this._subMenuStack.isEmpty()) {
            throw new IllegalStateException("Already on the top level!");
        }
        this._subMenuStack.pop();
        return this;
    }

    public JMenu bulidMenu(String name) {
        JMenu result = new JMenu(name);
        for (JMenuItem item : this._topLevelItems) {
            result.add(item);
        }
        return result;
    }

    public JMenuBar buildMenuBar() {
        JMenuBar result = new JMenuBar();
        for (JMenuItem item : this._topLevelItems) {
            if (!(item instanceof JMenu)) {
                throw new IllegalStateException("Top level contains items!");
            }
            result.add((JMenu)item);
        }
        return result;
    }

    public JPopupMenu buildPopupMenu(String sLabel) {
        JPopupMenu result = new JPopupMenu(sLabel);
        for (JMenuItem item : this._topLevelItems) {
            result.add(item);
        }
        return result;
    }

    private void add(JMenuItem item) {
        if (this._subMenuStack.isEmpty()) {
            this._topLevelItems.add(item);
        } else {
            JMenu parentMenu = this._subMenuStack.peek();
            parentMenu.add(item);
        }
    }
}

