/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.sf.javagimmicks.beans.BeanPropertyComparator;
import net.sf.javagimmicks.collections.SortedListUtils;
import net.sf.javagimmicks.swing.model.ListTableModel;

public class SortedTableUtils {

    protected static class HeaderSortMouseListener
    extends MouseAdapter {
        protected final SortTableSuite<?> _sortTableSuite;

        protected HeaderSortMouseListener(SortTableSuite<?> sortTableSuite) {
            this._sortTableSuite = sortTableSuite;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader tableHeader = (JTableHeader)e.getSource();
            TableColumnModel columnModel = tableHeader.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column == -1) {
                return;
            }
            String propertyName = this._sortTableSuite._tableModel.getPropertyNames().get(column);
            BeanPropertyComparator.SortOrder sortOrder = this._sortTableSuite._comparator.getSortOrder(propertyName);
            switch (sortOrder) {
                case ASCENDING: {
                    this._sortTableSuite._comparator.setSortOrder(propertyName, BeanPropertyComparator.SortOrder.DESCENDING);
                    break;
                }
                case DESCENDING: {
                    this._sortTableSuite._comparator.setSortOrder(propertyName, BeanPropertyComparator.SortOrder.NONE);
                    break;
                }
                case NONE: {
                    this._sortTableSuite._comparator.setSortOrder(propertyName, BeanPropertyComparator.SortOrder.ASCENDING);
                }
            }
            this._sortTableSuite.resort();
        }
    }

    protected static class ResortTableModelListener
    implements TableModelListener {
        protected final SortTableSuite<?> _sortTableSuite;
        protected boolean _enabled = true;

        protected ResortTableModelListener(SortTableSuite<?> sortTableSuite) {
            this._sortTableSuite = sortTableSuite;
        }

        protected void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!this._enabled) {
                return;
            }
            int column = e.getColumn();
            List<String> tablePropertyNames = this._sortTableSuite._tableModel.getPropertyNames();
            List<String> sortedProperties = this._sortTableSuite._comparator.getBeanPropertyNames();
            if (column == -1 && !sortedProperties.isEmpty()) {
                this._sortTableSuite.resort();
            } else {
                String propertyName = tablePropertyNames.get(column);
                if (sortedProperties.contains(propertyName)) {
                    this._sortTableSuite.resort();
                }
            }
        }
    }

    protected static class SortTableSuite<E> {
        protected final List<E> _rowData;
        protected final HeaderSortMouseListener _headerSortMouseListener;
        protected final ResortTableModelListener _resortTableModelListener;
        protected BeanPropertyComparator<E> _comparator;
        protected ListTableModel<E> _tableModel;
        protected List<E> _rowDataInterface;

        protected SortTableSuite(Class<E> rowType, List<E> rowData) {
            this._rowData = rowData;
            this._headerSortMouseListener = new HeaderSortMouseListener(this);
            this._comparator = new BeanPropertyComparator();
            this._tableModel = new ListTableModel<E>(this._rowData, rowType);
            this._rowDataInterface = SortedListUtils.decorate(this._tableModel, this._comparator);
            this._resortTableModelListener = new ResortTableModelListener(this);
            this._tableModel.addTableModelListener(this._resortTableModelListener);
        }

        protected List<E> applyTo(JTable table) {
            table.setModel(this._tableModel);
            table.getTableHeader().addMouseListener(this._headerSortMouseListener);
            return this._rowDataInterface;
        }

        protected void resort() {
            this._resortTableModelListener.setEnabled(false);
            SortedListUtils.resort(this._rowDataInterface);
            this._resortTableModelListener.setEnabled(true);
        }
    }
}

