/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.builder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.sf.javagimmicks.swing.builder.PanelBuilder;

public class ComponentBuilder<C extends JComponent, P extends PanelBuilder<?>> {
    private final P _parentBuilder;
    private final C _component;

    ComponentBuilder(P parentBuilder, C component) {
        this._parentBuilder = parentBuilder;
        this._component = component;
    }

    public P finish() {
        return this._parentBuilder;
    }

    public C get() {
        return this._component;
    }

    public ComponentBuilder<C, P> border(Border border) {
        ((JComponent)this.get()).setBorder(border);
        return this;
    }

    public ComponentBuilder<C, P> font(Font font) {
        ((JComponent)this.get()).setFont(font);
        return this;
    }

    public ComponentBuilder<C, P> enabled(boolean enabled) {
        ((JComponent)this.get()).setEnabled(enabled);
        return this;
    }

    public ComponentBuilder<C, P> background(Color color) {
        ((JComponent)this.get()).setBackground(color);
        return this;
    }

    public ComponentBuilder<C, P> foreground(Color color) {
        ((JComponent)this.get()).setForeground(color);
        return this;
    }

    public ComponentBuilder<C, P> focusListener(FocusListener focusListener) {
        ((Component)this.get()).addFocusListener(focusListener);
        return this;
    }

    public ComponentBuilder<C, P> keyListener(KeyListener keyListener) {
        ((Component)this.get()).addKeyListener(keyListener);
        return this;
    }

    public ComponentBuilder<C, P> mouseListener(MouseListener mouseListener) {
        ((Component)this.get()).addMouseListener(mouseListener);
        return this;
    }

    public ComponentBuilder<C, P> propertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ((Container)this.get()).addPropertyChangeListener(propertyChangeListener);
        return this;
    }

    protected P getParent() {
        return this._parentBuilder;
    }
}

