/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils15;
import net.sf.javagimmicks.swing.model.AbstractTypedTreeNode;
import net.sf.javagimmicks.swing.model.TypedChildTreeNode;
import net.sf.javagimmicks.swing.model.TypedParentTreeNode;
import net.sf.javagimmicks.swing.model.TypedTreeNode;

public abstract class AbstractTypedParentTreeNode<Value, ChildValue, ChildNode extends TypedChildTreeNode<? extends ChildValue, Value, ? extends TypedParentTreeNode<?, ?, ?>>>
extends AbstractTypedTreeNode<Value>
implements TypedParentTreeNode<Value, ChildValue, ChildNode> {
    protected AbstractTypedParentTreeNode(Value value, boolean noChildrenMeansLeaf) {
        super(value, true, noChildrenMeansLeaf);
    }

    protected AbstractTypedParentTreeNode(Value value) {
        super(value, true);
    }

    @Override
    public Enumeration<? extends ChildNode> children() {
        List<ChildNode> childNodesList = this.getChildNodes();
        return Collections.enumeration(childNodesList);
    }

    @Override
    public ChildNode getChildAt(int childIndex) {
        return this.buildChildNode(this.getChildValues().get(childIndex));
    }

    @Override
    public int getChildCount() {
        return this.getChildValues().size();
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!(node instanceof TypedTreeNode)) {
            return -1;
        }
        Object childValue = ((TypedTreeNode)node).getValue();
        return this.getChildValues().indexOf(childValue);
    }

    protected List<ChildNode> getChildNodes() {
        List childValues = this.getChildValues();
        if (childValues == null || childValues.isEmpty()) {
            return Collections.emptyList();
        }
        return TransformerUtils15.decorate(childValues, new Transformer<ChildValue, ChildNode>(){

            @Override
            public ChildNode transform(ChildValue childValue) {
                return AbstractTypedParentTreeNode.this.buildChildNode(childValue);
            }
        });
    }

    protected abstract ChildNode buildChildNode(ChildValue var1);
}

