/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.util.List;
import javax.swing.ComboBoxModel;
import net.sf.javagimmicks.swing.model.ListModelAdapter;

public class ComboBoxModelAdapter<E>
extends ListModelAdapter<E>
implements ComboBoxModel {
    private static final long serialVersionUID = -5100057877489621837L;
    protected Object m_oSelectedItem;

    public ComboBoxModelAdapter() {
    }

    public ComboBoxModelAdapter(List<E> oInternalList) {
        super(oInternalList);
    }

    @Override
    public Object getSelectedItem() {
        return this.m_oSelectedItem;
    }

    @Override
    public void setSelectedItem(Object oItem) {
        if (this.m_oSelectedItem != null && !this.m_oSelectedItem.equals(oItem) || this.m_oSelectedItem == null && oItem != null) {
            this.m_oSelectedItem = oItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public ComboBoxModelAdapter<E> subList(int iFromIndex, int iToIndex) {
        return new SubListDecorator(this, iFromIndex, iToIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ComboBoxModelAdapter)) {
            return false;
        }
        ComboBoxModelAdapter oOther = (ComboBoxModelAdapter)o;
        boolean bSelectedEqual = this.m_oSelectedItem == null && oOther.m_oSelectedItem == null || this.m_oSelectedItem == null || oOther.m_oSelectedItem == null || this.m_oSelectedItem.equals(oOther.m_oSelectedItem);
        return bSelectedEqual && super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 32768 + (this.m_oSelectedItem == null ? 0 : this.m_oSelectedItem.hashCode());
    }

    protected static class SubListDecorator<E>
    extends ComboBoxModelAdapter<E> {
        private static final long serialVersionUID = -5301211360041031237L;
        protected final int m_iOffset;
        protected final ComboBoxModelAdapter<E> m_oParent;

        protected SubListDecorator(ComboBoxModelAdapter<E> oParent, int iFromIndex, int iToIndex) {
            super(oParent._internalList.subList(iFromIndex, iToIndex));
            this.m_oParent = oParent;
            this.m_iOffset = iFromIndex;
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
            if (source == this && index0 >= 0 && index1 >= 0) {
                ((ComboBoxModelAdapter)this.m_oParent).fireContentsChanged(this.m_oParent, this.m_iOffset + index0, this.m_iOffset + index1);
            }
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            super.fireIntervalAdded(source, index0, index1);
            if (source == this) {
                ((ComboBoxModelAdapter)this.m_oParent).fireIntervalAdded(this.m_oParent, this.m_iOffset + index0, this.m_iOffset + index1);
            }
        }

        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            super.fireIntervalRemoved(source, index0, index1);
            if (source == this) {
                ((ComboBoxModelAdapter)this.m_oParent).fireIntervalRemoved(this.m_oParent, this.m_iOffset + index0, this.m_iOffset + index1);
            }
        }
    }
}

