/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DependencyComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = -2427435990181503056L;
    private final List<ComboBoxModel> _parentModels;
    private final Map<CompositeKey, ComboBoxList> _modelData = new HashMap<CompositeKey, ComboBoxList>();
    private final ListDataListener _listDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() == -1 && e.getIndex1() == -1) {
                DependencyComboBoxModel.this.update();
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    };
    private ComboBoxList _currentModelData;

    public DependencyComboBoxModel(List<ComboBoxModel> parentModels) {
        this._parentModels = new ArrayList<ComboBoxModel>(parentModels);
        for (ComboBoxModel parentModel : this._parentModels) {
            parentModel.addListDataListener(this._listDataListener);
        }
        this.update();
    }

    public DependencyComboBoxModel(ComboBoxModel ... parentModels) {
        this(Arrays.asList(parentModels));
    }

    public void registerModel(Object[] modelData, Object ... parentValues) {
        this.registerModel(Arrays.asList(modelData), parentValues);
    }

    public void registerModel(List<?> modelData, Object ... parentValues) {
        this.registerModel(new CompositeKey(parentValues), modelData);
    }

    @Override
    public Object getSelectedItem() {
        return this._currentModelData.getSelected();
    }

    void registerModel(CompositeKey key, List<?> modelData) {
        this._modelData.put(key, new ComboBoxList(modelData));
        this.update();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        Object oSelectedItem = this.getSelectedItem();
        if (oSelectedItem != null && !oSelectedItem.equals(anItem) || oSelectedItem == null && anItem != null) {
            this._currentModelData.setSelected(anItem);
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this._currentModelData.getList().get(index);
    }

    @Override
    public int getSize() {
        return this._currentModelData.getList().size();
    }

    private void update() {
        Object[] parentValues = new Object[this._parentModels.size()];
        ListIterator<ComboBoxModel> iterParentModels = this._parentModels.listIterator();
        while (iterParentModels.hasNext()) {
            parentValues[iterParentModels.nextIndex()] = iterParentModels.next().getSelectedItem();
        }
        int oldSize = this._currentModelData == null ? 0 : this.getSize();
        ComboBoxList currentModelData = this._modelData.get(new CompositeKey(parentValues));
        if (currentModelData == null) {
            this._currentModelData = new ComboBoxList(Collections.EMPTY_LIST);
        } else {
            this._currentModelData = currentModelData;
            if (this._currentModelData.getSelected() == null && !this._currentModelData.getList().isEmpty()) {
                this._currentModelData.setSelected(this._currentModelData.getList().get(0));
            }
        }
        int newSize = this.getSize();
        this.fireContentsChanged(this, 0, Math.min(oldSize, newSize));
        if (newSize > oldSize) {
            this.fireIntervalAdded(this, oldSize, newSize);
        } else if (newSize < oldSize) {
            this.fireIntervalRemoved(this, newSize, oldSize);
        }
        this.fireContentsChanged(this, -1, -1);
    }

    static class CompositeKey {
        private Object[] _keys;

        public CompositeKey(Object ... keys) {
            this._keys = keys;
        }

        public int getSize() {
            return this._keys.length;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CompositeKey)) {
                return false;
            }
            CompositeKey other = (CompositeKey)obj;
            return Arrays.equals(this._keys, other._keys);
        }

        public int hashCode() {
            int result = 0;
            for (Object keyPart : this._keys) {
                result = result * 17 + keyPart.hashCode();
            }
            return result += 748923479;
        }
    }

    private static class ComboBoxList {
        private Object _selectedItem;
        private List<?> _data;

        public ComboBoxList(List<?> data) {
            this._data = data;
        }

        public Object getSelected() {
            return this._selectedItem;
        }

        public void setSelected(Object item) {
            this._selectedItem = item;
        }

        public List<?> getList() {
            return this._data;
        }
    }
}

