/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import net.sf.javagimmicks.swing.model.DependencyComboBoxModel;

public class DependencyComboBoxModelBuilder {
    private Map<DependencyComboBoxModel.CompositeKey, Vector<Object>> _modelData = new HashMap<DependencyComboBoxModel.CompositeKey, Vector<Object>>();
    private Stack<Object> _parentsStack = new Stack();
    private Object _lastAdded;
    private List<Object> _currentData = new ArrayList<Object>();

    public DependencyComboBoxModelBuilder add(Object item) {
        this._currentData.add(item);
        this._lastAdded = item;
        return this;
    }

    public DependencyComboBoxModelBuilder children() {
        if (this._lastAdded == null) {
            throw new IllegalStateException("No objects added yet!");
        }
        this.addCurrentElements();
        this._parentsStack.push(this._lastAdded);
        this._lastAdded = null;
        return this;
    }

    public DependencyComboBoxModelBuilder parent() {
        if (this._parentsStack.isEmpty()) {
            throw new IllegalStateException("Already on the top level!");
        }
        this.addCurrentElements();
        this._lastAdded = this._parentsStack.pop();
        return this;
    }

    public List<ComboBoxModel> buildModels() {
        this.addCurrentElements();
        ArrayList dataByLevel = new ArrayList();
        for (Map.Entry<DependencyComboBoxModel.CompositeKey, Vector<Object>> entry : this._modelData.entrySet()) {
            int dataLevelCount;
            int n = entry.getKey().getSize();
            if (n >= (dataLevelCount = dataByLevel.size())) {
                for (int i = 0; i <= n - dataLevelCount; ++i) {
                    dataByLevel.add(new ArrayList());
                }
            }
            ((List)dataByLevel.get(n)).add(entry);
        }
        ArrayList<ComboBoxModel> result = new ArrayList<ComboBoxModel>(dataByLevel.size());
        for (List list : dataByLevel) {
            AbstractListModel model;
            if (result.isEmpty()) {
                assert (list.size() == 1);
                model = new DefaultComboBoxModel((Vector)((Map.Entry)list.get(0)).getValue());
            } else {
                DependencyComboBoxModel depModel = new DependencyComboBoxModel(result);
                for (Map.Entry entry : list) {
                    depModel.registerModel((DependencyComboBoxModel.CompositeKey)entry.getKey(), (List)entry.getValue());
                }
                model = depModel;
            }
            result.add((ComboBoxModel)((Object)model));
        }
        return result;
    }

    private void addCurrentElements() {
        if (this._currentData.isEmpty()) {
            return;
        }
        DependencyComboBoxModel.CompositeKey key = new DependencyComboBoxModel.CompositeKey(this._parentsStack.toArray());
        Vector<Object> data = this._modelData.get(key);
        if (data == null) {
            data = new Vector();
            this._modelData.put(key, data);
        }
        data.addAll(this._currentData);
        this._currentData.clear();
    }
}

